/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.heat;

import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public enum Heat {
    WARMING("warming", 1.0f, 80.0f, ChatFormatting.GRAY),
    HOT("hot", 80.0f, 210.0f, ChatFormatting.GRAY),
    VERY_HOT("very_hot", 210.0f, 480.0f, ChatFormatting.GRAY),
    FAINT_RED("faint_red", 480.0f, 580.0f, ChatFormatting.DARK_RED),
    DARK_RED("dark_red", 580.0f, 730.0f, ChatFormatting.DARK_RED),
    BRIGHT_RED("bright_red", 730.0f, 930.0f, ChatFormatting.RED),
    ORANGE("orange", 930.0f, 1100.0f, ChatFormatting.GOLD),
    YELLOW("yellow", 1100.0f, 1300.0f, ChatFormatting.YELLOW),
    YELLOW_WHITE("yellow_white", 1300.0f, 1400.0f, ChatFormatting.YELLOW),
    WHITE("white", 1400.0f, 1500.0f, ChatFormatting.WHITE),
    BRILLIANT_WHITE("brilliant_white", 1500.0f, 1600.0f, ChatFormatting.WHITE);

    private static final Heat[] VALUES;
    private final ChatFormatting color;
    private final String translationKey;
    private final float min;
    private final float max;

    public static float maxVisibleTemperature() {
        return BRILLIANT_WHITE.getMax();
    }

    @Nullable
    public static Heat getHeat(float temperature) {
        if (temperature >= Heat.WARMING.min) {
            for (Heat heat : VALUES) {
                if (!(temperature < heat.max)) continue;
                return heat;
            }
            return BRILLIANT_WHITE;
        }
        return null;
    }

    private Heat(String name, float min, float max, ChatFormatting color) {
        this.min = min;
        this.max = max;
        this.translationKey = "tfc.enum.heat." + name;
        this.color = color;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public MutableComponent getDisplayName() {
        return Helpers.translatable(this.translationKey);
    }

    static {
        VALUES = Heat.values();
    }
}

