/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import java.util.List;
import java.util.Random;
import java.util.function.DoubleSupplier;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;

public enum ForgingBonus {
    NONE(() -> Double.POSITIVE_INFINITY),
    POORLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilPoorlyForgedThreshold).get()),
    WELL_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilWellForgedThreshold).get()),
    EXPERTLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilExpertForgedThreshold).get()),
    PERFECTLY_FORGED(() -> ((ForgeConfigSpec.DoubleValue)TFCConfig.SERVER.anvilPerfectlyForgedThreshold).get());

    private static final String KEY = "tfc:forging_bonus";
    private static final ForgingBonus[] VALUES;
    private final DoubleSupplier minRatio;

    public static ForgingBonus valueOf(int i) {
        return i < 0 ? VALUES[0] : (i >= VALUES.length ? VALUES[VALUES.length - 1] : VALUES[i]);
    }

    public static ForgingBonus byRatio(float ratio) {
        for (int i = VALUES.length - 1; i > 0; --i) {
            if (!(ForgingBonus.VALUES[i].minRatio.getAsDouble() > (double)ratio)) continue;
            return VALUES[i];
        }
        return NONE;
    }

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        ForgingBonus bonus = ForgingBonus.get(stack);
        if (bonus != NONE) {
            tooltips.add((Component)Helpers.translateEnum(bonus).m_130940_(ChatFormatting.GREEN));
        }
    }

    public static boolean applyLikeUnbreaking(ItemStack stack, Random random) {
        ForgingBonus bonus;
        if (stack.m_41763_() && (bonus = ForgingBonus.get(stack)) != NONE) {
            return random.nextFloat() < bonus.durability();
        }
        return false;
    }

    public static ForgingBonus get(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY, 3)) {
            return ForgingBonus.valueOf(tag.m_128451_(KEY));
        }
        return NONE;
    }

    public static void set(ItemStack stack, ForgingBonus bonus) {
        if (bonus != NONE) {
            stack.m_41784_().m_128405_(KEY, bonus.ordinal());
        } else {
            stack.m_41749_(KEY);
        }
    }

    private ForgingBonus(DoubleSupplier minRatio) {
        this.minRatio = minRatio;
    }

    public float efficiency() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, ((Double)TFCConfig.SERVER.anvilMaxEfficiencyMultiplier.get()).floatValue());
    }

    public float durability() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 0.0f, ((Double)TFCConfig.SERVER.anvilMaxDurabilityMultiplier.get()).floatValue());
    }

    public float damage() {
        return Helpers.lerp((float)this.ordinal() * 0.25f, 1.0f, ((Double)TFCConfig.SERVER.anvilMaxDamageMultiplier.get()).floatValue());
    }

    static {
        VALUES = ForgingBonus.values();
    }
}

