/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.Arrays;
import java.util.LinkedList;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ToFloatFunction;

public class NutritionData {
    private final LinkedList<FoodData> records = new LinkedList();
    private final float defaultNutritionValue;
    private final float defaultDairyNutritionValue;
    private final float[] nutrients;
    private float averageNutrients;
    private int hungerWindow;

    public NutritionData(float defaultNutritionValue, float defaultDairyNutritionValue) {
        this.defaultNutritionValue = defaultNutritionValue;
        this.defaultDairyNutritionValue = defaultDairyNutritionValue;
        this.nutrients = new float[5];
        this.hungerWindow = 0;
        this.calculateNutrition();
    }

    public void reset() {
        this.records.clear();
        this.calculateNutrition();
    }

    public float getAverageNutrition() {
        return this.averageNutrients;
    }

    public float getNutrient(Nutrient nutrient) {
        return this.nutrients[nutrient.ordinal()];
    }

    public float[] getNutrients() {
        return this.nutrients;
    }

    public void onClientUpdate(float[] nutrients) {
        System.arraycopy(nutrients, 0, this.nutrients, 0, this.nutrients.length);
        this.updateAverageNutrients();
    }

    public void addNutrients(FoodData data) {
        if (data.hunger() > 0 || this.records.isEmpty() || this.records.getFirst().hunger() > 0) {
            this.records.addFirst(data);
            this.calculateNutrition();
        }
    }

    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag recordsNbt = new ListTag();
        for (FoodData data : this.records) {
            recordsNbt.add((Object)data.write());
        }
        nbt.m_128365_("records", (Tag)recordsNbt);
        return nbt;
    }

    public void readFromNbt(CompoundTag nbt) {
        this.records.clear();
        ListTag recordsNbt = nbt.m_128437_("records", 10);
        for (int i = 0; i < recordsNbt.size(); ++i) {
            this.records.add(FoodData.read(recordsNbt.m_128728_(i)));
        }
        this.calculateNutrition();
    }

    private void calculateNutrition() {
        Arrays.fill(this.nutrients, 0.0f);
        int runningHungerTotal = 0;
        this.hungerWindow = (Integer)TFCConfig.SERVER.nutritionRotationHungerWindow.get();
        for (int i = 0; i < this.records.size(); ++i) {
            FoodData record = this.records.get(i);
            int nextHunger = record.hunger() + runningHungerTotal;
            if (nextHunger <= this.hungerWindow) {
                this.updateAllNutrients(this.nutrients, (ToFloatFunction<Nutrient>)((ToFloatFunction)j -> this.nutrients[j.ordinal()] + record.nutrient((Nutrient)((Object)j)) * (float)Math.max(record.hunger(), 4)));
                runningHungerTotal = nextHunger;
                continue;
            }
            float actualHunger = this.hungerWindow - runningHungerTotal;
            this.updateAllNutrients(this.nutrients, (ToFloatFunction<Nutrient>)((ToFloatFunction)j -> this.nutrients[j.ordinal()] + record.nutrient((Nutrient)((Object)j)) * actualHunger));
            while (this.records.size() > i + 1) {
                this.records.remove(i + 1);
            }
        }
        this.updateAllNutrients(this.nutrients, (ToFloatFunction<Nutrient>)((ToFloatFunction)j -> this.nutrients[j.ordinal()] / (float)this.hungerWindow));
        if (runningHungerTotal < this.hungerWindow) {
            float defaultModifier = 1.0f - (float)runningHungerTotal / (float)this.hungerWindow;
            for (Nutrient nutrient : Nutrient.VALUES) {
                if (nutrient == Nutrient.DAIRY) {
                    int n = nutrient.ordinal();
                    this.nutrients[n] = this.nutrients[n] + this.defaultDairyNutritionValue * defaultModifier;
                    continue;
                }
                int n = nutrient.ordinal();
                this.nutrients[n] = this.nutrients[n] + this.defaultNutritionValue * defaultModifier;
            }
        }
        this.updateAllNutrients(this.nutrients, (ToFloatFunction<Nutrient>)((ToFloatFunction)j -> Math.min(1.0f, this.nutrients[j.ordinal()])));
        this.updateAverageNutrients();
    }

    private void updateAverageNutrients() {
        this.averageNutrients = 0.0f;
        for (float nutrient : this.nutrients) {
            this.averageNutrients += nutrient;
        }
        this.averageNutrients /= (float)Nutrient.TOTAL;
    }

    private void updateAllNutrients(float[] array, ToFloatFunction<Nutrient> operator) {
        for (Nutrient nutrient : Nutrient.VALUES) {
            array[nutrient.ordinal()] = operator.m_183321_((Object)nutrient);
        }
    }
}

