/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public final class ItemStackCapabilitySync {
    public static boolean hasSyncableCapability(ItemStack stack) {
        return stack.getCapability(FoodCapability.NETWORK_CAPABILITY).isPresent() || stack.getCapability(HeatCapability.NETWORK_CAPABILITY).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToNetwork(ItemStack stack, FriendlyByteBuf buffer) {
        ItemStack itemStack = stack;
        synchronized (itemStack) {
            if (ItemStackCapabilitySync.hasSyncableCapability(stack)) {
                buffer.writeBoolean(true);
                ItemStackCapabilitySync.writeToNetwork(FoodCapability.NETWORK_CAPABILITY, stack, buffer);
                ItemStackCapabilitySync.writeToNetwork(HeatCapability.NETWORK_CAPABILITY, stack, buffer);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }

    public static void readFromNetwork(ItemStack stack, FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            ItemStackCapabilitySync.readFromNetwork(FoodCapability.NETWORK_CAPABILITY, stack, buffer);
            ItemStackCapabilitySync.readFromNetwork(HeatCapability.NETWORK_CAPABILITY, stack, buffer);
        }
    }

    private static void writeToNetwork(Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack, FriendlyByteBuf buffer) {
        buffer.m_130079_((CompoundTag)stack.getCapability(capability).map(INBTSerializable::serializeNBT).orElse(null));
    }

    private static void readFromNetwork(Capability<? extends INBTSerializable<CompoundTag>> capability, ItemStack stack, FriendlyByteBuf buffer) {
        CompoundTag tag = buffer.m_130260_();
        if (tag != null) {
            stack.getCapability(capability).ifPresent(cap -> cap.deserializeNBT((Tag)tag));
        }
    }
}

