/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.HorizontalPipeBlock;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSupportBlock
extends Block
implements IForgeBlockExtension,
IFluidLoggable,
HorizontalPipeBlock {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private final Map<BlockState, VoxelShape> cachedShapes;
    private final ExtendedProperties properties;

    public VerticalSupportBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.cachedShapes = this.makeShapes(VerticalSupportBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (ImmutableList<BlockState>)this.m_49965_().m_61056_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutablePos.m_122159_((Vec3i)context.m_8083_(), d);
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(d), (Comparable)Boolean.valueOf(Helpers.isBlock(context.m_43725_().m_8055_((BlockPos)mutablePos), TFCTags.Blocks.SUPPORT_BEAM)));
        }
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        state = (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
        return state;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.m_5776_() || placer == null) {
            return;
        }
        if (stack.m_41613_() > 2 && !placer.m_6144_()) {
            BlockPos above = pos.m_7494_();
            BlockPos above2 = above.m_7494_();
            BlockState stateAbove = level.m_8055_(above);
            BlockState stateAbove2 = level.m_8055_(above2);
            Fluid fluidAbove = stateAbove.m_60819_().m_76152_();
            Fluid fluidAbove2 = stateAbove2.m_60819_().m_76152_();
            if (this.isEmptyOrValidFluid(stateAbove) && this.isEmptyOrValidFluid(stateAbove2) && level.m_45933_(null, new AABB(above)).isEmpty()) {
                level.m_7731_(above, (BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidAbove)), 2);
                if (level.m_45933_(null, new AABB(above2)).isEmpty()) {
                    level.m_7731_(above2, (BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluidAbove2)), 2);
                    stack.m_41774_(2);
                } else {
                    stack.m_41774_(1);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (facing.m_122434_().m_122479_()) {
            state = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAM)));
        } else if (facing == Direction.DOWN) {
            if (Helpers.isBlock(facingState, TFCTags.Blocks.SUPPORT_BEAM) || facingState.m_60659_((BlockGetter)level, facingPos, Direction.UP, SupportType.CENTER)) {
                return state;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return Helpers.isBlock(belowState, TFCTags.Blocks.SUPPORT_BEAM) || belowState.m_60659_((BlockGetter)level, belowPos, Direction.UP, SupportType.CENTER);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.cachedShapes.get(state);
        if (shape != null) {
            return shape;
        }
        throw new IllegalArgumentException("Asked for Support VoxelShape that was not cached");
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, FLUID}));
    }

    protected Map<BlockState, VoxelShape> makeShapes(VoxelShape middleShape, ImmutableList<BlockState> possibleStates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : possibleStates) {
            VoxelShape shape = middleShape;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(d))).booleanValue()) continue;
                VoxelShape joinShape = switch (d) {
                    case Direction.NORTH -> VerticalSupportBlock.m_49796_((double)5.0, (double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)10.0);
                    case Direction.SOUTH -> VerticalSupportBlock.m_49796_((double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0, (double)16.0);
                    case Direction.EAST -> VerticalSupportBlock.m_49796_((double)11.0, (double)10.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);
                    case Direction.WEST -> VerticalSupportBlock.m_49796_((double)0.0, (double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0);
                    default -> Shapes.m_83040_();
                };
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)joinShape);
            }
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    protected boolean isEmptyOrValidFluid(BlockState state) {
        return FluidHelpers.isAirOrEmptyFluid(state) && this.getFluidProperty().canContain(state.m_60819_().m_76152_());
    }
}

