/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCLoomBlock
extends BottomSupportedDeviceBlock
implements IFluidLoggable {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private static final VoxelShape SHAPE_EAST = TFCLoomBlock.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)8.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = TFCLoomBlock.m_49796_((double)8.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH = TFCLoomBlock.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_NORTH = TFCLoomBlock.m_49796_((double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)16.0, (double)14.0);
    private final ResourceLocation woodTexture;

    public TFCLoomBlock(ExtendedProperties properties, ResourceLocation woodTexture) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.woodTexture = woodTexture;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    public ResourceLocation getTextureLocation() {
        return this.woodTexture;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_6425_(pos).m_76178_()) {
            return InteractionResult.PASS;
        }
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LOOM.get()).map(loom -> loom.onRightClick(player)).orElse(InteractionResult.PASS);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            state = FluidHelpers.fillWithFluid(state, context.m_43725_().m_6425_(context.m_8083_()).m_76152_());
        }
        return state == null ? null : (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLUID});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

