/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DryingBricksBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.MudBlock;
import net.dries007.tfc.common.blocks.soil.PathBlock;
import net.dries007.tfc.common.blocks.soil.TFCRootedDirtBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public enum SoilBlockType {
    DIRT((self, variant) -> new DirtBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(1.4f).m_60918_(SoundType.f_56739_), self.transform(), (RegistrySoilVariant)variant)),
    GRASS((self, variant) -> new ConnectedGrassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60977_().m_60978_(1.8f).m_60918_(SoundType.f_56740_), self.transform(), (RegistrySoilVariant)variant)),
    GRASS_PATH((self, variant) -> new PathBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(1.5f).m_60918_(SoundType.f_56740_), self.transform(), (RegistrySoilVariant)variant)),
    CLAY((self, variant) -> new DirtBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(1.5f).m_60918_(SoundType.f_56739_), self.transform(), (RegistrySoilVariant)variant)),
    CLAY_GRASS((self, variant) -> new ConnectedGrassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60977_().m_60978_(1.8f).m_60918_(SoundType.f_56740_), self.transform(), (RegistrySoilVariant)variant)),
    FARMLAND((self, variant) -> new FarmlandBlock(ExtendedProperties.of(Material.f_76314_, MaterialColor.f_76408_).strength(1.3f).sound(SoundType.f_56739_).isViewBlocking(TFCBlocks::always).isSuffocating(TFCBlocks::always).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.FARMLAND), (RegistrySoilVariant)variant)),
    ROOTED_DIRT((self, variant) -> new TFCRootedDirtBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(2.0f).m_60918_(SoundType.f_154672_), self.transform(), (RegistrySoilVariant)variant)),
    MUD((self, variant) -> new MudBlock(SoilBlockType.mudProperties())),
    MUD_BRICKS((self, variant) -> new Block(SoilBlockType.mudBrickProperties())),
    DRYING_BRICKS((self, variant) -> new DryingBricksBlock(ExtendedProperties.of(Material.f_76310_).noCollission().noOcclusion().instabreak().sound(SoundType.f_56763_).randomTicks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), variant.getDriedMudBrick()));

    public static final SoilBlockType[] VALUES;
    private final BiFunction<SoilBlockType, RegistrySoilVariant, Block> factory;

    public static SoilBlockType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : DIRT;
    }

    public static BlockBehaviour.Properties mudProperties() {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(1.6f).m_60918_(SoundType.f_56719_).m_60956_(0.8f).m_60924_(TFCBlocks::always).m_60971_(TFCBlocks::always).m_60960_(TFCBlocks::always);
    }

    public static BlockBehaviour.Properties mudBrickProperties() {
        return BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_60978_(2.6f).m_60918_(SoundType.f_56719_);
    }

    private SoilBlockType(BiFunction<SoilBlockType, RegistrySoilVariant, Block> factory) {
        this.factory = factory;
    }

    public Block create(RegistrySoilVariant variant) {
        return this.factory.apply(this, variant);
    }

    private SoilBlockType transform() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case DIRT -> GRASS;
            case GRASS, GRASS_PATH, FARMLAND, ROOTED_DIRT, MUD, MUD_BRICKS, DRYING_BRICKS -> DIRT;
            case CLAY -> CLAY_GRASS;
            case CLAY_GRASS -> CLAY;
        };
    }

    static {
        VALUES = SoilBlockType.values();
    }

    public static enum Variant implements RegistrySoilVariant
    {
        SILT,
        LOAM,
        SANDY_LOAM,
        SILTY_LOAM;

        private static final Variant[] VALUES;

        public static Variant valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : SILT;
        }

        @Override
        public Supplier<? extends Block> getBlock(SoilBlockType type) {
            return (Supplier)TFCBlocks.SOIL.get((Object)type).get(this);
        }

        @Override
        public Supplier<? extends Item> getDriedMudBrick() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SILT -> TFCItems.SILT_MUD_BRICK;
                case LOAM -> TFCItems.LOAM_MUD_BRICK;
                case SANDY_LOAM -> TFCItems.SANDY_LOAM_MUD_BRICK;
                case SILTY_LOAM -> TFCItems.SILTY_LOAM_MUD_BRICK;
            };
        }

        static {
            VALUES = Variant.values();
        }
    }
}

