/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.blocks.wood.TFCLeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FruitTreeLeavesBlock
extends SeasonalPlantBlock
implements IForgeBlockExtension,
ILeavesBlock,
IBushBlock,
HoeOverlayBlock,
IFluidLoggable {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    private static final int MONTHS_SPENT_DORMANT_TO_DIE = 4;

    public static int getHydration(Level level, BlockPos pos) {
        return (int)(Climate.getRainfall(level, pos) / 5.0f);
    }

    public FruitTreeLeavesBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange, productItem, stages);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_(LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(context.m_43723_() != null))).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        IBushBlock.randomTick(this, state, level, pos, random);
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            Lifecycle expectedLifecycle;
            BerryBushBlockEntity leaves = (BerryBushBlockEntity)blockEntity;
            Lifecycle currentLifecycle = (Lifecycle)((Object)state.m_61143_(LIFECYCLE));
            if (!FruitTreeLeavesBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth())) {
                long deltaTicks = Math.min(leaves.getTicksSinceBushUpdate(), Calendars.SERVER.getCalendarTicksInYear());
                long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
                long nextCalendarTick = currentCalendarTick - deltaTicks;
                ClimateRange range = (ClimateRange)this.climateRange.get();
                int hydration = FruitTreeLeavesBlock.getHydration(level, pos);
                int monthsSpentDying = 0;
                do {
                    nextCalendarTick = Math.min(nextCalendarTick + Calendars.SERVER.getCalendarTicksInMonth(), currentCalendarTick);
                    float temperatureAtNextTick = Climate.getTemperature(level, pos, nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth());
                    Lifecycle lifecycleAtNextTick = this.getLifecycleForMonth(ICalendar.getMonthOfYear(nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth()));
                    currentLifecycle = range.checkBoth(hydration, temperatureAtNextTick, false) ? currentLifecycle.advanceTowards(lifecycleAtNextTick) : Lifecycle.DORMANT;
                    if (lifecycleAtNextTick != Lifecycle.DORMANT && currentLifecycle == Lifecycle.DORMANT) {
                        ++monthsSpentDying;
                        continue;
                    }
                    monthsSpentDying = 0;
                } while (nextCalendarTick < currentCalendarTick);
                BlockState newState = this.mayDie(level, pos, state, monthsSpentDying) ? Blocks.f_50016_.m_49966_() : (BlockState)state.m_61124_(LIFECYCLE, (Comparable)((Object)currentLifecycle));
                if (state != newState) {
                    level.m_7731_(pos, newState, 3);
                }
            }
        }
    }

    @Override
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        TFCLeavesBlock.onEntityInside(state, level, pos, entity);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = (ClimateRange)this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos, range, false, FruitTreeLeavesBlock.getHydration(level, pos)));
        text.add(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected boolean mayDie(Level level, BlockPos pos, BlockState state, int monthsSpentDying) {
        return monthsSpentDying >= 4;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIFECYCLE, PERSISTENT, this.getFluidProperty()});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (this.isValid(level, currentPos, state)) {
            return state;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            TFCLeavesBlock.doParticles(server, (float)currentPos.m_123341_() + level.m_5822_().nextFloat(), (float)currentPos.m_123342_() + level.m_5822_().nextFloat(), (float)currentPos.m_123343_() + level.m_5822_().nextFloat(), 1);
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!this.isValid((LevelAccessor)level, pos, state)) {
            level.m_46961_(pos, true);
            TFCLeavesBlock.doParticles(level, (float)pos.m_123341_() + rand.nextFloat(), (float)pos.m_123342_() + rand.nextFloat(), (float)pos.m_123343_() + rand.nextFloat(), 1);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    private boolean isValid(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            return true;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Helpers.DIRECTIONS) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(direction);
            if (!Helpers.isBlock(level.m_8055_((BlockPos)mutablePos), TFCTags.Blocks.FRUIT_TREE_BRANCH)) continue;
            return true;
        }
        return false;
    }
}

