/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class TallWaterPlantBlock
extends TFCTallGrassBlock
implements IFluidLoggable {
    public static final EnumProperty<ITallPlant.Part> PART = TFCBlockStateProperties.TALL_PLANT_PART;

    public static TallWaterPlantBlock create(final RegistryPlant plant, final FluidProperty fluid, BlockBehaviour.Properties properties) {
        return new TallWaterPlantBlock(ExtendedProperties.of(properties)){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TallWaterPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_))).m_61124_(PART, (Comparable)((Object)ITallPlant.Part.LOWER)));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (state.m_61143_(PART) == ITallPlant.Part.LOWER) {
            return Helpers.isBlock(belowState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        if (state.m_60734_() != this) {
            return Helpers.isBlock(belowState, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
        }
        return belowState.m_60734_() == this && belowState.m_61143_(PART) == ITallPlant.Part.LOWER;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState state = this.updateStateWithCurrentMonth(this.m_49966_());
        if (this.getFluidProperty().canContain(fluidState.m_76152_())) {
            state = (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return pos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(pos.m_7494_()).m_60629_(context) ? state : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{this.getFluidProperty()}));
    }

    @Override
    public void placeTwoHalves(LevelAccessor level, BlockPos pos, int flags, Random random) {
        BlockPos posAbove = pos.m_7494_();
        int age = random.nextInt(4);
        Fluid fluidBottom = level.m_6425_(pos).m_76152_();
        Fluid fluidTop = level.m_6425_(posAbove).m_76152_();
        if (!fluidBottom.m_6212_(Fluids.f_76191_)) {
            BlockState state = FluidHelpers.fillWithFluid((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_(PART, (Comparable)((Object)ITallPlant.Part.LOWER)), fluidBottom);
            BlockState stateUp = FluidHelpers.fillWithFluid((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_(PART, (Comparable)((Object)ITallPlant.Part.UPPER)), fluidTop);
            if (state != null && stateUp != null) {
                level.m_7731_(pos, state, flags);
                level.m_7731_(posAbove, stateUp, flags);
            }
        }
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }
}

