/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ShortGrassBlock
extends PlantBlock {
    protected static final VoxelShape GRASS_SHAPE = ShortGrassBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHORTER_GRASS_SHAPE = ShortGrassBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHORT_GRASS_SHAPE = ShortGrassBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHORTEST_GRASS_SHAPE = ShortGrassBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public static ShortGrassBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new ShortGrassBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected ShortGrassBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockPos newPos;
        super.m_7455_(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random) && (newPos = PlantRegrowth.spreadSelf(state, level, pos, random, 2, 2, 4)) != null) {
            level.m_46597_(newPos, this.updateStateWithCurrentMonth((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))));
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)AGE)) {
            case 0 -> SHORTEST_GRASS_SHAPE;
            case 1 -> SHORTER_GRASS_SHAPE;
            case 2 -> SHORT_GRASS_SHAPE;
            default -> GRASS_SHAPE;
        };
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(state.m_60734_(), TFCTags.Blocks.GRASS_PLANTABLE_ON);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }
}

