/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class PitKilnBlock
extends DeviceBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.PIT_KILN_STAGE;
    public static final int STRAW_END = 7;
    public static final int LOG_START = 8;
    public static final int LIT = 16;
    public static final VoxelShape[] SHAPE_BY_LAYER = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[17], shapes -> {
        int i;
        for (i = 0; i < 8; ++i) {
            shapes[i] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
        }
        for (i = 0; i < 4; ++i) {
            shapes[8 + i] = Shapes.m_83110_((VoxelShape)shapes[7 + i], (VoxelShape)Block.m_49796_((double)(4 * i), (double)8.0, (double)0.0, (double)(4 * (i + 1)), (double)12.0, (double)16.0));
        }
        for (i = 0; i < 4; ++i) {
            shapes[12 + i] = Shapes.m_83110_((VoxelShape)shapes[11 + i], (VoxelShape)Block.m_49796_((double)(4 * i), (double)12.0, (double)0.0, (double)(4 * (i + 1)), (double)16.0, (double)16.0));
        }
        shapes[16] = Shapes.m_83144_();
    });

    public PitKilnBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)STAGE) == 16) {
            double x = (float)pos.m_123341_() + random.nextFloat();
            double y = (float)pos.m_123342_() + random.nextFloat();
            double z = (float)pos.m_123343_() + random.nextFloat();
            for (int i = 0; i < random.nextInt(3); ++i) {
                level.m_7107_((ParticleOptions)ParticleTypes.f_123778_, x, y, z, 0.0, (double)(0.1f + random.nextFloat() / 8.0f), 0.0);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{STAGE}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        PitKilnBlockEntity kiln;
        BlockEntity blockEntity;
        if (facing == Direction.DOWN && !facingState.m_60783_((BlockGetter)level, facingPos, Direction.UP)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (facing == Direction.UP && facingState.m_60734_() == Blocks.f_50083_ && (blockEntity = level.m_7702_(currentPos)) instanceof PitKilnBlockEntity && !(kiln = (PitKilnBlockEntity)blockEntity).isLit()) {
            level.m_7731_(facingPos, Blocks.f_50016_.m_49966_(), 3);
            if (kiln.tryLight()) {
                return (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(16));
            }
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && hand == InteractionHand.MAIN_HAND && (blockEntity = level.m_7702_(pos)) instanceof PitKilnBlockEntity) {
            PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
            ItemStack held = player.m_21120_(hand);
            Item item = held.m_41720_();
            int stage = (Integer)state.m_61143_((Property)STAGE);
            if (stage < 7 && Helpers.isItem(item, TFCTags.Items.PIT_KILN_STRAW)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 10);
                kiln.addStraw(held.m_41620_(1), stage + 1);
                Helpers.playPlaceSound(level, pos, SoundType.f_56740_);
            } else if (stage >= 7 && stage < 15 && Helpers.isItem(item, TFCTags.Items.PIT_KILN_LOGS)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 10);
                kiln.addLog(held.m_41620_(1), stage - 8 + 1);
                Helpers.playPlaceSound(level, pos, SoundType.f_56736_);
            } else if (held.m_41619_() && stage != 16) {
                ItemStack dropStack;
                NonNullList<ItemStack> logItems = kiln.getLogs();
                NonNullList<ItemStack> strawItems = kiln.getStraws();
                if (stage >= 8) {
                    dropStack = ((ItemStack)logItems.get(stage - 8)).m_41777_();
                    kiln.deleteLog(stage - 8);
                } else {
                    dropStack = ((ItemStack)strawItems.get(stage)).m_41777_();
                    kiln.deleteStraw(stage);
                }
                if (!dropStack.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)dropStack);
                }
                if (stage == 0) {
                    PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos);
                } else {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage - 1)), 10);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)STAGE)];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levle, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)STAGE)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)STAGE)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.m_61143_((Property)STAGE)];
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult result, BlockGetter level, BlockPos pos, Player player) {
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PitKilnBlockEntity) {
                PitKilnBlockEntity placedItem = (PitKilnBlockEntity)blockEntity;
                return placedItem.getCloneItemStack(state, blockResult);
            }
        }
        return ItemStack.f_41583_;
    }
}

