/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class TFCBubbleColumnBlock
extends BubbleColumnBlock {
    private static final double MAX_DOWN_SPEED = -0.1;
    private static final double MAX_UP_SPEED = 0.3;
    private final Supplier<? extends Fluid> fluid;

    public static void updateColumnForFluid(LevelAccessor level, BlockPos pos, BlockState state, Fluid fluid) {
        TFCBubbleColumnBlock.updateColumnForFluid(level, pos, level.m_8055_(pos), state, fluid);
    }

    public static void updateColumnForFluid(LevelAccessor level, BlockPos pos, BlockState aboveState, BlockState belowState, Fluid fluid) {
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        if (TFCBubbleColumnBlock.canExistIn(aboveState, fluid)) {
            BlockState blockstate = TFCBubbleColumnBlock.getColumnState(belowState, fluid);
            level.m_7731_(pos, blockstate, 2);
            BlockPos.MutableBlockPos mutable = pos.m_122032_().m_122173_(Direction.UP);
            while (TFCBubbleColumnBlock.canExistIn(level.m_8055_((BlockPos)mutable), fluid)) {
                if (!level.m_7731_((BlockPos)mutable, blockstate, 2)) {
                    return;
                }
                mutable.m_122173_(Direction.UP);
            }
        }
    }

    private static BlockState getColumnState(BlockState state, Fluid fluid) {
        BlockState toPlace;
        BlockState blockState = toPlace = fluid.m_6212_((Fluid)Fluids.f_76193_) ? ((Block)TFCBlocks.FRESHWATER_BUBBLE_COLUMN.get()).m_49966_() : ((Block)TFCBlocks.SALTWATER_BUBBLE_COLUMN.get()).m_49966_();
        if (state.m_60734_() instanceof BubbleColumnBlock) {
            return state;
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.CREATES_DOWNWARD_BUBBLES)) {
            return (BlockState)toPlace.m_61124_((Property)f_50956_, (Comparable)Boolean.valueOf(true));
        }
        if (Helpers.isBlock(state, TFCTags.Blocks.CREATES_UPWARD_BUBBLES)) {
            return (BlockState)toPlace.m_61124_((Property)f_50956_, (Comparable)Boolean.valueOf(false));
        }
        return fluid.m_76145_().m_76188_();
    }

    private static boolean canExistIn(BlockState state, Fluid fluid) {
        return state.m_60734_() instanceof BubbleColumnBlock || state.m_60819_().m_76152_().m_6212_(fluid) && state.m_60819_().m_76186_() >= 8 && state.m_60819_().m_76170_();
    }

    public TFCBubbleColumnBlock(BlockBehaviour.Properties properties, Supplier<? extends Fluid> fluid) {
        super(properties);
        this.fluid = fluid;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (Helpers.isEntity(entity, TFCTags.Entities.BUBBLE_COLUMN_IMMUNE)) {
            return;
        }
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        if (aboveState.m_60795_()) {
            this.modifyEntityMovement(entity, (Boolean)state.m_61143_((Property)f_50956_), true);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + level.f_46441_.nextDouble(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + level.f_46441_.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + level.f_46441_.nextDouble(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + level.f_46441_.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            this.modifyEntityMovement(entity, (Boolean)state.m_61143_((Property)f_50956_), false);
        }
    }

    private void modifyEntityMovement(Entity entity, boolean dragDown, boolean above) {
        Vec3 movement = entity.m_20184_();
        double dy = dragDown ? Math.max(above ? -0.9 : -0.1, movement.f_82480_ - 0.03) : (above ? Math.min(1.8, movement.f_82480_ + 0.1) : Math.min(0.3, movement.f_82480_ + 0.06));
        entity.m_20334_(movement.f_82479_, dy, movement.f_82481_);
        if (!above) {
            entity.m_183634_();
        }
    }

    public FluidState m_5888_(BlockState state) {
        return this.getFluid().m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        level.m_186469_(pos, this.getFluid(), this.getFluid().m_6718_((LevelReader)level));
        if (!state.m_60710_((LevelReader)level, pos) || facing == Direction.DOWN || facing == Direction.UP && !(facingState.m_60734_() instanceof BubbleColumnBlock) && TFCBubbleColumnBlock.canExistIn(facingState, this.getFluid())) {
            level.m_186460_(pos, (Block)this, 5);
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random p_50974_) {
        TFCBubbleColumnBlock.updateColumnForFluid((LevelAccessor)level, pos, state, level.m_8055_(pos.m_7495_()), this.getFluid());
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)this.getFluid().m_6859_());
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

