/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.container.PowderkegContainer;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.PowderKegExplosion;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowderkegBlockEntity
extends TickableInventoryBlockEntity<PowderkegInventory> {
    public static final int SLOTS = 12;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.powderkeg");
    private int fuse = -1;
    private boolean isLit = false;
    @Nullable
    private Entity igniter;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PowderkegBlockEntity powderkeg) {
        if (powderkeg.isLit) {
            --powderkeg.fuse;
            if (powderkeg.fuse <= 0) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                PowderkegBlockEntity.explode(powderkeg);
            }
        }
    }

    public static int getStrength(PowderkegBlockEntity powderkeg) {
        return PowderkegBlockEntity.getStrength((IItemHandler)powderkeg.inventory);
    }

    public static int getStrength(IItemHandler inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            count += inventory.getStackInSlot(i).m_41613_();
        }
        return Math.min(64, Mth.m_14107_((double)((Double)TFCConfig.SERVER.powderKegStrengthModifier.get() * (double)count / 12.0)));
    }

    private static void explode(PowderkegBlockEntity powderkeg) {
        assert (powderkeg.f_58857_ != null);
        PowderKegExplosion explosion = new PowderKegExplosion(powderkeg.f_58857_, powderkeg.igniter, powderkeg.f_58858_.m_123341_(), powderkeg.f_58858_.m_123342_(), powderkeg.f_58858_.m_123343_(), PowderkegBlockEntity.getStrength(powderkeg));
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public PowderkegBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.POWDERKEG.get(), pos, state, PowderkegInventory::new, NAME);
        if (((Boolean)TFCConfig.SERVER.powderKegEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insertAll(), Direction.UP);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return PowderkegContainer.create(this, player.m_150109_(), containerId);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.USABLE_IN_POWDER_KEG);
    }

    public void onSeal() {
        this.markForSync();
    }

    public void onUnseal() {
        this.markForSync();
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isLit() {
        return this.isLit;
    }

    public void setLit(boolean lit, @Nullable Entity igniter) {
        if (!((Boolean)TFCConfig.SERVER.powderKegEnabled.get()).booleanValue()) {
            if (igniter instanceof Player) {
                Player player = (Player)igniter;
                player.m_5661_((Component)Helpers.translatable("tfc.tooltip.powderkeg.disabled"), true);
            }
            return;
        }
        this.isLit = lit;
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PowderkegBlock.LIT, (Comparable)Boolean.valueOf(lit)));
        if (lit) {
            Helpers.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_12512_);
            this.fuse = 80;
            this.igniter = igniter;
            if (igniter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)igniter;
                if (PowderkegBlockEntity.getStrength(this) >= 64) {
                    TFCAdvancements.FULL_POWDERKEG.trigger(serverPlayer);
                }
            }
        } else {
            Helpers.playSound(this.f_58857_, this.f_58858_, (SoundEvent)TFCSounds.ITEM_COOL.get());
            this.fuse = -1;
        }
        this.markForSync();
    }

    public static class PowderkegInventory
    implements DelegateItemHandler,
    INBTSerializable<CompoundTag>,
    EmptyInventory {
        private final PowderkegBlockEntity powderkeg;
        private final InventoryItemHandler inventory;

        PowderkegInventory(InventoryBlockEntity<?> entity) {
            this.powderkeg = (PowderkegBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 12);
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.canModify() ? this.inventory.insertItem(slot, stack, simulate) : stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.canModify() ? this.inventory.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        private boolean canModify() {
            return (Boolean)this.powderkeg.m_58900_().m_61143_((Property)PowderkegBlock.SEALED) == false;
        }
    }
}

