/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class PlacedItemBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOT_LARGE_ITEM = 0;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.placed_item");
    public boolean isHoldingLargeItem = false;

    public static void convertPlacedItemToPitKiln(Level level, BlockPos pos, ItemStack strawStack) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(placedItem -> {
            NonNullList<ItemStack> items = Helpers.extractAllItems(placedItem.inventory);
            level.m_46597_(pos, ((Block)TFCBlocks.PIT_KILN.get()).m_49966_());
            placedItem.m_7651_();
            level.m_5594_(null, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 0.5f, 1.0f);
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PIT_KILN.get()).ifPresent(pitKiln -> {
                Helpers.insertAllItems(pitKiln.inventory, items);
                pitKiln.isHoldingLargeItem = placedItem.isHoldingLargeItem;
                pitKiln.addStraw(strawStack, 0);
            });
        });
    }

    public static int getSlotSelected(BlockHitResult rayTrace) {
        Vec3 location = rayTrace.m_82450_();
        boolean x = (double)Math.round(location.f_82479_) < location.f_82479_;
        boolean z = (double)Math.round(location.f_82481_) < location.f_82481_;
        return (x ? 1 : 0) + (z ? 2 : 0);
    }

    public PlacedItemBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PLACED_ITEM.get(), pos, state);
    }

    protected PlacedItemBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, self -> new InventoryItemHandler(self, 4), NAME);
    }

    public boolean onRightClick(Player player, ItemStack stack, BlockHitResult rayTrace) {
        Vec3 location = rayTrace.m_82450_();
        return this.onRightClick(player, stack, (double)Math.round(location.f_82479_) < location.f_82479_, (double)Math.round(location.f_82481_) < location.f_82481_);
    }

    public boolean insertItem(Player player, ItemStack stack, BlockHitResult rayTrace) {
        return this.insertItem(player, stack, PlacedItemBlockEntity.getSlotSelected(rayTrace));
    }

    public boolean onRightClick(Player player, ItemStack stack, boolean x, boolean z) {
        int slot = (x ? 1 : 0) + (z ? 2 : 0);
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() || player.m_6144_()) {
            ItemStack current = this.isHoldingLargeItem ? ((ItemStackHandler)this.inventory).getStackInSlot(0) : ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            if (!current.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)current.m_41777_());
                ((ItemStackHandler)this.inventory).setStackInSlot(this.isHoldingLargeItem ? 0 : slot, ItemStack.f_41583_);
                this.isHoldingLargeItem = false;
                this.updateBlock();
                return true;
            }
        } else if (!stack.m_41619_()) {
            return this.insertItem(player, stack, slot);
        }
        return false;
    }

    public boolean insertItem(Player player, ItemStack stack, int slot) {
        Size size = ItemSizeManager.get(stack).getSize(stack);
        if (Helpers.isItem(stack, TFCTags.Items.PLACED_ITEM_BLACKLIST) || ((Boolean)TFCConfig.SERVER.usePlacedItemWhitelist.get()).booleanValue() && !Helpers.isItem(stack, TFCTags.Items.PLACED_ITEM_WHITELIST)) {
            return false;
        }
        if (size.isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.maxPlacedItemSize.get())) && !this.isHoldingLargeItem) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(slot).m_41619_()) {
                ItemStack input;
                if (player.m_7500_()) {
                    input = stack.m_41777_();
                    input.m_41764_(1);
                } else {
                    input = stack.m_41620_(1);
                }
                ((ItemStackHandler)this.inventory).setStackInSlot(slot, input);
                this.updateBlock();
                return true;
            }
        } else if (!size.isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.maxPlacedItemSize.get())) && size.isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.maxPlacedLargeItemSize.get())) && this.isEmpty()) {
            ItemStack input;
            if (player.m_7500_()) {
                input = stack.m_41777_();
                input.m_41764_(1);
            } else {
                input = stack.m_41620_(1);
            }
            ((ItemStackHandler)this.inventory).setStackInSlot(0, input);
            this.isHoldingLargeItem = true;
            this.updateBlock();
            return true;
        }
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, BlockHitResult hit) {
        return ((ItemStackHandler)this.inventory).getStackInSlot(PlacedItemBlockEntity.getSlotSelected(hit)).m_41777_();
    }

    public boolean holdingLargeItem() {
        return this.isHoldingLargeItem;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.isHoldingLargeItem = nbt.m_128471_("isHoldingLargeItem");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_("isHoldingLargeItem", this.isHoldingLargeItem);
        super.m_183515_(nbt);
    }

    protected void updateBlock() {
        if (this.isEmpty() && this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        } else {
            this.markForBlockUpdate();
        }
    }

    protected boolean isEmpty() {
        if (this.isHoldingLargeItem && ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_()) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }
}

