/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class IngotPileBlockEntity
extends TFCBlockEntity {
    private final List<ItemStack> stacks = new ArrayList<ItemStack>();
    private final List<Metal> cachedMetals = new ArrayList<Metal>();

    public IngotPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.INGOT_PILE.get(), pos, state);
    }

    public void addIngot(ItemStack stack) {
        assert (this.stacks.size() == this.cachedMetals.size());
        this.stacks.add(stack);
        this.cachedMetals.add(null);
        this.markForSync();
    }

    public List<ItemStack> removeAllIngots() {
        assert (this.stacks.size() == this.cachedMetals.size());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.stacks);
        this.stacks.clear();
        this.cachedMetals.clear();
        this.markForSync();
        return stacks;
    }

    public ItemStack removeIngot() {
        assert (this.stacks.size() == this.cachedMetals.size());
        ItemStack remove = this.stacks.remove(this.stacks.size() - 1);
        this.cachedMetals.remove(this.cachedMetals.size() - 1);
        this.markForSync();
        return remove;
    }

    public Metal getOrCacheMetal(int index) {
        assert (this.stacks.size() == this.cachedMetals.size());
        if (index >= this.stacks.size()) {
            return Metal.unknown();
        }
        ItemStack stack = this.stacks.get(index);
        Metal metal = this.cachedMetals.get(index);
        if (metal == null) {
            metal = Metal.getFromIngot(stack);
            if (metal == null) {
                metal = Metal.unknown();
            }
            this.cachedMetals.set(index, metal);
        }
        return metal;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("stacks", (Tag)Helpers.writeItemStacksToNbt(this.stacks));
        super.m_183515_(tag);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        Helpers.readItemStacksFromNbt(this.stacks, tag.m_128437_("stacks", 10));
        this.cachedMetals.clear();
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.cachedMetals.add(null);
        }
        super.loadAdditional(tag);
    }

    public void fillTooltip(Consumer<Component> tooltip) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Metal metal2 : this.cachedMetals) {
            if (metal2 == null) continue;
            map.mergeInt((Object)metal2, 1, Integer::sum);
        }
        map.forEach((metal, ct) -> tooltip.accept((Component)Helpers.literal(ct + "x ").m_7220_((Component)metal.getDisplayName())));
    }
}

