/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.SimpleFluidHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.AlloyView;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IntArrayBuilder;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlockEntity
extends TickableInventoryBlockEntity<CrucibleInventory>
implements ICalendarTickable {
    public static final int SLOTS = 10;
    public static final int SLOT_INPUT_START = 0;
    public static final int SLOT_INPUT_END = 8;
    public static final int SLOT_OUTPUT = 9;
    private static final Component NAME = Helpers.translatable("tfc.tile_entity.crucible");
    private static final int TARGET_TEMPERATURE_STABILITY_TICKS = 5;
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;
    private final SidedHandler.Noop<IHeatBlock> sidedHeat;
    private final IntArrayBuilder syncableData;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[9];
    private float temperature = 0.0f;
    private float targetTemperature = 0.0f;
    private boolean needsRecipeUpdate = true;
    private int targetTemperatureStabilityTicks;
    private int lastFillTicks = 0;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private int fastPourSlot = 0;
    private int fastPourTicks = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        crucible.checkForLastTickSync();
        crucible.checkForCalendarUpdate();
        if (crucible.needsRecipeUpdate) {
            crucible.needsRecipeUpdate = false;
            crucible.updateCaches();
        }
        if (crucible.temperature != crucible.targetTemperature) {
            crucible.temperature = HeatCapability.adjustTempTowards(crucible.temperature, crucible.targetTemperature);
        }
        if (crucible.targetTemperatureStabilityTicks > 0) {
            --crucible.targetTemperatureStabilityTicks;
        }
        if (crucible.targetTemperature > 0.0f && crucible.targetTemperatureStabilityTicks == 0) {
            crucible.targetTemperature = HeatCapability.adjustTempTowards(crucible.targetTemperature, 0.0f);
        }
        boolean canFill = crucible.lastFillTicks <= 0;
        for (int i = 0; i <= 8; ++i) {
            ItemStack drainStack;
            MoldLike mold;
            int slot = i;
            ItemStack inputStack = ((CrucibleInventory)crucible.inventory).getStackInSlot(i);
            if (!inputStack.m_41619_()) {
                inputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> {
                    HeatCapability.addTemp(cap, crucible.temperature, 2.0f + crucible.temperature * 0.0025f);
                    HeatingRecipe recipe = crucible.cachedRecipes[slot];
                    if (recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
                        ItemStackInventory inventory = new ItemStackInventory(inputStack);
                        ItemStack outputItem = recipe.assemble(inventory);
                        FluidStack outputFluid = recipe.assembleFluid(inventory);
                        FoodCapability.applyTrait(outputItem, FoodTraits.BURNT_TO_A_CRISP);
                        outputItem.getCapability(HeatCapability.CAPABILITY).ifPresent(outputCap -> outputCap.setTemperature(crucible.temperature));
                        ((CrucibleInventory)crucible.inventory).setStackInSlot(slot, outputItem);
                        ((CrucibleInventory)crucible.inventory).fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
                        crucible.markForSync();
                    }
                });
            }
            if (!canFill || (mold = MoldLike.get(drainStack = ((CrucibleInventory)crucible.inventory).getStackInSlot(i))) == null || !mold.isMolten() || !FluidHelpers.transferExact((IFluidHandler)mold, (IFluidHandler)crucible.inventory, 1)) continue;
            if (crucible.fastPourTicks >= 0 && crucible.fastPourSlot == i) {
                --crucible.fastPourTicks;
                crucible.lastFillTicks = (Integer)TFCConfig.SERVER.crucibleFastPouringRate.get();
            } else {
                crucible.lastFillTicks = (Integer)TFCConfig.SERVER.cruciblePouringRate.get();
            }
            crucible.markForSync();
        }
        if (crucible.lastFillTicks > 0) {
            --crucible.lastFillTicks;
        }
        if (((CrucibleInventory)crucible.inventory).isMolten()) {
            FluidStack outputDrop = ((CrucibleInventory)crucible.inventory).drain(1, IFluidHandler.FluidAction.SIMULATE);
            FluidStack outputRemainder = Helpers.mergeOutputFluidIntoSlot(crucible.inventory, outputDrop, crucible.temperature, 9);
            if (outputRemainder.isEmpty()) {
                ((CrucibleInventory)crucible.inventory).drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            crucible.markForSync();
        }
    }

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CRUCIBLE.get(), pos, state, CrucibleInventory::new, NAME);
        this.sidedFluidInventory = new SidedHandler.Builder<IFluidHandler>((IFluidHandler)this.inventory);
        if (((Boolean)TFCConfig.SERVER.crucibleEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0, 1, 2, 3, 4, 5, 6, 7, 8), Direction.UP).on(new PartialItemHandler(this.inventory).insert(9).extract(9), (Predicate<Direction>)Direction.Plane.HORIZONTAL);
            this.sidedFluidInventory.on((IFluidHandler)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), Direction.UP).on((IFluidHandler)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), (Predicate<Direction>)Direction.Plane.HORIZONTAL);
        }
        this.sidedHeat = new SidedHandler.Noop<IHeatBlock>((IHeatBlock)this.inventory);
        this.syncableData = new IntArrayBuilder().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
    }

    public float getTemperature() {
        return this.temperature;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    public AlloyView getAlloy() {
        return ((CrucibleInventory)this.inventory).alloy;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 9) {
            return Helpers.mightHaveCapability(stack, Capabilities.FLUID_ITEM, HeatCapability.CAPABILITY);
        }
        return Helpers.mightHaveCapability(stack, HeatCapability.CAPABILITY);
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        this.targetTemperature = HeatCapability.adjustTempTowards(this.targetTemperature, 0.0f, ticks);
        this.temperature = HeatCapability.adjustTempTowards(this.temperature, this.targetTemperature, ticks);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    @Deprecated
    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    @Override
    @Deprecated
    public void setLastUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return CrucibleContainer.create(this, player.m_150109_(), containerId);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("temperature");
        this.targetTemperature = nbt.m_128457_("targetTemperature");
        this.targetTemperatureStabilityTicks = nbt.m_128451_("targetTemperatureStabilityTicks");
        this.lastUpdateTick = nbt.m_128454_("lastUpdateTick");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128350_("targetTemperature", this.targetTemperature);
        nbt.m_128405_("targetTemperatureStabilityTicks", this.targetTemperatureStabilityTicks);
        nbt.m_128379_("empty", Helpers.isEmpty((IItemHandler)this.inventory) && ((CrucibleInventory)this.inventory).alloy.isEmpty());
        nbt.m_128356_("lastUpdateTick", this.lastUpdateTick);
        super.m_183515_(nbt);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        if (cap == HeatCapability.BLOCK_CAPABILITY) {
            return this.sidedHeat.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (slot != 9) {
            this.cachedRecipes[slot] = HeatingRecipe.getRecipe(((CrucibleInventory)this.inventory).getStackInSlot(slot));
        }
    }

    public void setFastPouring(int slot) {
        this.fastPourSlot = slot;
        this.fastPourTicks = 20;
    }

    private void updateCaches() {
        for (int slot = 0; slot <= 8; ++slot) {
            this.cachedRecipes[slot] = HeatingRecipe.getRecipe(((CrucibleInventory)this.inventory).getStackInSlot(slot));
        }
    }

    static class CrucibleInventory
    implements DelegateItemHandler,
    SimpleFluidHandler,
    INBTSerializable<CompoundTag>,
    IHeatBlock {
        private final CrucibleBlockEntity crucible;
        private final InventoryItemHandler inventory;
        private final Alloy alloy;

        CrucibleInventory(InventoryBlockEntity<?> entity) {
            this.crucible = (CrucibleBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 10);
            this.alloy = new Alloy((Integer)TFCConfig.SERVER.crucibleCapacity.get());
        }

        public boolean isMolten() {
            assert (this.crucible.f_58857_ != null);
            return this.crucible.temperature > this.alloy.getResult(this.crucible.f_58857_).getMeltTemperature();
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("alloy", (Tag)this.alloy.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.alloy.deserializeNBT(nbt.m_128469_("alloy"));
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.alloy.getResultAsFluidStack();
        }

        public int getTankCapacity(int tank) {
            return this.alloy.getMaxUnits();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return Metal.get(stack.getFluid()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            Metal metal = Metal.get(resource.getFluid());
            if (metal != null) {
                return this.alloy.add(metal, resource.getAmount(), action.simulate());
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.isMolten()) {
                assert (this.crucible.f_58857_ != null);
                Metal result = this.alloy.getResult(this.crucible.f_58857_);
                int amount = this.alloy.removeAlloy(maxDrain, action.simulate());
                if (action.execute()) {
                    this.crucible.markForSync();
                }
                return new FluidStack(result.getFluid(), amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public float getTemperature() {
            return this.crucible.temperature;
        }

        @Override
        public void setTemperature(float temperature) {
            this.crucible.targetTemperature = temperature;
            this.crucible.targetTemperatureStabilityTicks = 5;
            this.crucible.markForSync();
        }

        @Override
        public void setTemperatureIfWarmer(float temperature) {
            if (temperature >= this.crucible.temperature) {
                this.crucible.temperature = temperature;
                this.crucible.targetTemperatureStabilityTicks = 5;
                this.crucible.markForSync();
            }
        }
    }
}

