/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.wood.BookshelfBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BookshelfBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Helpers.translatable("tfc.block_entity.bookshelf");

    public BookshelfBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<ItemStackHandler> inventoryFactory, Component defaultName) {
        super(type, pos, state, inventoryFactory, defaultName);
    }

    public BookshelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BOOKSHELF.get(), pos, state, BookshelfBlockEntity.defaultInventory(6), NAME);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.USABLE_IN_BOOKSHELF);
    }

    public InteractionResult use(Player player, ItemStack stack) {
        assert (this.f_58857_ != null);
        if (stack.m_41619_()) {
            for (int i = ((ItemStackHandler)this.inventory).getSlots() - 1; i >= 0; --i) {
                if (((ItemStackHandler)this.inventory).getStackInSlot(i).m_41619_()) continue;
                if (!this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(i, 1, false));
                }
                this.updateBookCount(i);
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        } else {
            for (int i = 0; i < ((ItemStackHandler)this.inventory).getSlots(); ++i) {
                if (!((ItemStackHandler)this.inventory).getStackInSlot(i).m_41619_() || !this.isItemValid(i, stack)) continue;
                ItemStack leftover = ((ItemStackHandler)this.inventory).insertItem(i, stack.m_41620_(1), false);
                if (!leftover.m_41619_() && !this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                }
                this.updateBookCount(i);
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.updateBookCount(slot);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null) {
            this.f_58857_.m_186460_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()).m_60734_(), 1);
        }
    }

    public int countBooks() {
        int found = 0;
        for (int i = 0; i < ((ItemStackHandler)this.inventory).getSlots(); ++i) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(i).m_41619_()) continue;
            ++found;
        }
        return found;
    }

    private void updateBookCount(int interactedSlot) {
        assert (this.f_58857_ != null);
        int found = this.countBooks();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BookshelfBlock.BOOKS_STORED) && state.m_61138_((Property)BookshelfBlock.LAST_INTERACTION_BOOK_SLOT) && ((Integer)state.m_61143_((Property)BookshelfBlock.BOOKS_STORED) != found || (Integer)state.m_61143_((Property)BookshelfBlock.LAST_INTERACTION_BOOK_SLOT) != interactedSlot)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)state.m_61124_((Property)BookshelfBlock.BOOKS_STORED, (Comparable)Integer.valueOf(found))).m_61124_((Property)BookshelfBlock.LAST_INTERACTION_BOOK_SLOT, (Comparable)Integer.valueOf(interactedSlot)));
        }
    }
}

