/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PourFasterPacket;
import net.dries007.tfc.util.AlloyView;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.network.PacketDistributor;

public class CrucibleScreen
extends BlockEntityScreen<CrucibleBlockEntity, CrucibleContainer> {
    private static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/crucible.png");
    private static final int MAX_ELEMENTS = 3;
    private int scrollPos;
    private boolean scrollPress;
    private int pourFasterDecayTicks = 0;

    public CrucibleScreen(CrucibleContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 55;
        this.f_97727_ += 55;
        this.scrollPos = 0;
        this.scrollPress = false;
    }

    protected void m_181908_() {
        if (this.pourFasterDecayTicks <= 0 && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            MoldLike mold;
            if (this.f_97734_ != null && (mold = MoldLike.get(this.f_97734_.m_7993_())) != null) {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new PourFasterPacket(((CrucibleBlockEntity)this.blockEntity).m_58899_(), this.f_97734_.f_40219_));
                this.pourFasterDecayTicks = 10;
            }
        } else {
            --this.pourFasterDecayTicks;
        }
        super.m_181908_();
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.f_97735_ + 154) && mouseX <= (double)(this.f_97735_ + 165) && mouseY >= (double)(this.f_97736_ + 11 + this.scrollPos) && mouseY <= (double)(this.f_97736_ + 26 + this.scrollPos)) {
            this.scrollPress = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrollPress) {
            this.scrollPos = Math.min(Math.max((int)mouseY - this.f_97736_ - 18, 0), 49);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.scrollPress && button == 0) {
            this.scrollPress = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int temperature = (int)(51.0f * ((CrucibleBlockEntity)this.blockEntity).getTemperature() / Heat.maxVisibleTemperature());
        if (temperature > 0) {
            this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 131 - Math.min(temperature, 51), 176, 0, 15, 5);
        }
        this.m_93228_(poseStack, this.f_97735_ + 154, this.f_97736_ + 11 + this.scrollPos, 176, 7, 12, 15);
        AlloyView alloy = ((CrucibleBlockEntity)this.blockEntity).getAlloy();
        if (alloy.getAmount() > 0) {
            TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite(alloy.getResultAsFluidStack());
            int fillHeight = (int)Math.ceil(31.0f * (float)alloy.getAmount() / (float)alloy.getMaxUnits());
            RenderHelpers.fillAreaWithSprite(poseStack, sprite, this.f_97735_ + 97, this.f_97736_ + 124 - fillHeight, 36, fillHeight, 16, 16);
            this.resetToBackgroundSprite();
            Metal result = alloy.getResult(ClientHelpers.getLevelOrThrow());
            String resultText = ChatFormatting.UNDERLINE + I18n.m_118938_((String)result.getTranslationKey(), (Object[])new Object[0]);
            this.f_96547_.m_92883_(poseStack, resultText, (float)(this.f_97735_ + 10), (float)(this.f_97736_ + 11), 0);
            int startElement = Math.max(0, (int)Math.floor((double)(alloy.getMetals().size() - 3) / 49.0 * (double)(this.scrollPos + 1)));
            int yPos = this.f_97736_ + 22;
            int index = -1;
            for (Object2DoubleMap.Entry entry : alloy.getMetals().object2DoubleEntrySet()) {
                if (++index < startElement) continue;
                if (index > startElement - 1 + 3) break;
                String metalName = this.f_96547_.m_92834_(I18n.m_118938_((String)((Metal)entry.getKey()).getTranslationKey(), (Object[])new Object[0]), 141) + ":";
                TranslatableComponent content = Helpers.translatable("tfc.tooltip.crucible_content_line", Tooltips.fluidUnits(entry.getDoubleValue()), String.format("%2.1f", Float.valueOf((float)Math.round(1000.0 * entry.getDoubleValue() / (double)alloy.getAmount()) / 10.0f)));
                this.f_96547_.m_92883_(poseStack, metalName, (float)(this.f_97735_ + 10), (float)yPos, 0x404040);
                this.f_96547_.m_92889_(poseStack, (Component)content, (float)(this.f_97735_ + 10), (float)(yPos + 9), 0x404040);
                yPos += 18;
            }
        }
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        MutableComponent text;
        super.m_7025_(poseStack, mouseX, mouseY);
        if (RenderHelpers.isInside(mouseX, mouseY, this.f_97735_ + 7, this.f_97736_ + 131 - 51, 15, 51) && (text = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(((CrucibleBlockEntity)this.blockEntity).getTemperature())) != null) {
            this.m_96602_(poseStack, (Component)text, mouseX, mouseY);
        }
    }
}

