/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.TFCStandingSignBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class TFCSignBlockEntityRenderer
extends SignRenderer {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font font;
    private final Map<Block, Material> materials;
    private final Map<Block, SignRenderer.SignModel> models;

    private static Material createSignMaterial(String domain, String name) {
        return new Material(Sheets.f_110739_, new ResourceLocation(domain, "entity/signs/" + name));
    }

    private static int getDarkColor(SignBlockEntity sign) {
        int i = sign.m_59753_().m_41071_();
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        return i == DyeColor.BLACK.m_41071_() && sign.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    private static boolean isOutlineVisible(SignBlockEntity sing, int dyeIndex) {
        if (dyeIndex == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)sing.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    public TFCSignBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this(context, TFCBlocks.WOODS.entrySet().stream().map(entry -> new SignModelData("tfc", ((Wood)entry.getKey()).m_7912_(), (Block)((RegistryObject)((Map)entry.getValue()).get((Object)Wood.BlockType.SIGN)).get(), (Block)((RegistryObject)((Map)entry.getValue()).get((Object)Wood.BlockType.WALL_SIGN)).get())));
    }

    public TFCSignBlockEntityRenderer(BlockEntityRendererProvider.Context context, Stream<SignModelData> blocks) {
        super(context);
        this.font = context.m_173586_();
        ImmutableMap.Builder materialBuilder = ImmutableMap.builder();
        ImmutableMap.Builder modelBuilder = ImmutableMap.builder();
        blocks.forEach(data -> {
            Material material = TFCSignBlockEntityRenderer.createSignMaterial(data.domain, data.name);
            SignRenderer.SignModel model = new SignRenderer.SignModel(context.m_173582_(new ModelLayerLocation(new ResourceLocation(data.domain, "sign/" + data.name), "main")));
            materialBuilder.put((Object)data.sign, (Object)material);
            materialBuilder.put((Object)data.wallSign, (Object)material);
            modelBuilder.put((Object)data.sign, (Object)model);
            modelBuilder.put((Object)data.wallSign, (Object)model);
        });
        this.materials = materialBuilder.build();
        this.models = modelBuilder.build();
    }

    public void m_6922_(SignBlockEntity sign, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight, int overlay) {
        int totalLight;
        boolean outline;
        int textColor;
        BlockState state = sign.m_58900_();
        poseStack.m_85836_();
        float scale = 0.6666667f;
        SignRenderer.SignModel model = this.models.get(state.m_60734_());
        if (state.m_60734_() instanceof TFCStandingSignBlock) {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            yRot = -((float)((Integer)state.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            poseStack.m_85845_(RenderHelpers.rotateDegreesY(yRot));
            model.f_112507_.f_104207_ = true;
        } else {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            yRot = -((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            poseStack.m_85845_(RenderHelpers.rotateDegreesY(yRot));
            poseStack.m_85837_(0.0, -0.3125, -0.4375);
            model.f_112507_.f_104207_ = false;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, -scale, -scale);
        Material material = this.materials.get(state.m_60734_());
        VertexConsumer vertexconsumer = material.m_119194_(source, arg_0 -> ((SignRenderer.SignModel)model).m_103119_(arg_0));
        model.f_173655_.m_104301_(poseStack, vertexconsumer, packedLight, overlay);
        poseStack.m_85849_();
        float rescale = 0.010416667f;
        poseStack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        poseStack.m_85841_(rescale, -rescale, rescale);
        int darkColor = TFCSignBlockEntityRenderer.getDarkColor(sign);
        FormattedCharSequence[] lines = sign.m_155717_(Minecraft.m_91087_().m_167974_(), component -> {
            List list = this.font.m_92923_((FormattedText)component, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (sign.m_155727_()) {
            textColor = sign.m_59753_().m_41071_();
            outline = TFCSignBlockEntityRenderer.isOutlineVisible(sign, textColor);
            totalLight = 0xF000F0;
        } else {
            textColor = darkColor;
            outline = false;
            totalLight = packedLight;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = lines[i1];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (outline) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), textColor, darkColor, poseStack.m_85850_().m_85861_(), source, totalLight);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), textColor, false, poseStack.m_85850_().m_85861_(), source, false, 0, totalLight);
        }
        poseStack.m_85849_();
    }

    public record SignModelData(String domain, String name, Block sign, Block wallSign) {
    }
}

