/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.ScrapingBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public class ScrapingBlockEntityRenderer
implements BlockEntityRenderer<ScrapingBlockEntity> {
    public void render(ScrapingBlockEntity scraping, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        scraping.getCapability(Capabilities.ITEM).ifPresent(cap -> {
            if (scraping.getInputTexture() != null && scraping.getOutputTexture() != null) {
                short positions = scraping.getScrapedPositions();
                this.drawTiles(buffer, poseStack, scraping.getInputTexture(), positions, 0, combinedLight, combinedOverlay, scraping.getColor1());
                this.drawTiles(buffer, poseStack, scraping.getOutputTexture(), positions, 1, combinedLight, combinedOverlay, scraping.getColor2());
            }
        });
    }

    private void drawTiles(MultiBufferSource buffer, PoseStack poseStack, ResourceLocation texture, short positions, int condition, int combinedLight, int combinedOverlay, float[] color) {
        Matrix4f mat = poseStack.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS).apply(texture);
        for (int xOffset = 0; xOffset < 4; ++xOffset) {
            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                if ((positions >> xOffset + 4 * zOffset & 1) != condition) continue;
                float r = color[0];
                float g = color[1];
                float b = color[2];
                builder.m_85982_(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0), sprite.m_118393_((double)zOffset * 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f, 0.01f, (float)zOffset / 4.0f + 0.25f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0), sprite.m_118393_((double)zOffset * 4.0 + 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f + 0.25f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0 + 4.0), sprite.m_118393_((double)zOffset * 4.0 + 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_85982_(mat, (float)xOffset / 4.0f + 0.25f, 0.01f, (float)zOffset / 4.0f).m_85950_(r, g, b, 1.0f).m_7421_(sprite.m_118367_((double)xOffset * 4.0 + 4.0), sprite.m_118393_((double)zOffset * 4.0)).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
    }
}

