/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.particle;

import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.client.particle.TFCParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidDripParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    public FluidDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
        super(level, x, y, z);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.type = fluid;
        int color = RenderHelpers.getFluidColor(this.type);
        this.f_107227_ = (float)(color >> 16 & 0xFF) / 255.0f;
        this.f_107228_ = (float)(color >> 8 & 0xFF) / 255.0f;
        this.f_107229_ = (float)(color & 0xFF) / 255.0f;
    }

    protected Fluid getFluid() {
        return this.type;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float partialTick) {
        return this.isGlowing ? 240 : super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
                FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
                if (fluidstate.m_76152_() == this.type && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    public static ParticleProvider<FluidParticleOption> provider(SpriteSet set, FluidParticleFactory factory) {
        return (type, level, x, y, z, dx, dy, dz) -> {
            FluidDripParticle particle = factory.create(level, x, y, z, type.getFluid());
            particle.m_108335_(set);
            return particle;
        };
    }

    public static interface FluidParticleFactory {
        public FluidDripParticle create(ClientLevel var1, double var2, double var4, double var6, Fluid var8);
    }

    public static class BarrelDripParticle
    extends FluidFallAndLandParticle {
        public BarrelDripParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            double dx = x - (double)Mth.m_14107_((double)x);
            double dz = z - (double)Mth.m_14107_((double)z);
            if (dx < 0.5) {
                this.f_107215_ = 0.01;
            } else if (dx > 0.5) {
                this.f_107215_ = -0.01;
            } else {
                this.f_107217_ = dz < 0.5 ? 0.01 : -0.01;
            }
        }
    }

    public static class FluidLandParticle
    extends FluidFallAndLandParticle {
        public FluidLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            super(level, x, y, z, fluid);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    public static class FluidFallAndLandParticle
    extends FluidDripParticle {
        private final ParticleOptions landingParticle;

        public FluidFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            this(level, x, y, z, fluid, new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.FLUID_LAND.get()), fluid));
        }

        public FluidFallAndLandParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions landParticle) {
            super(level, x, y, z, fluid);
            this.landingParticle = landParticle;
            this.f_107225_ = 40;
            this.f_107226_ *= 0.02f;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landingParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class FluidHangParticle
    extends FluidDripParticle {
        private final ParticleOptions fallingParticle;

        public FluidHangParticle(ClientLevel level, double x, double y, double z, Fluid fluid) {
            this(level, x, y, z, fluid, new FluidParticleOption((ParticleType<FluidParticleOption>)((ParticleType)TFCParticles.FLUID_FALL.get()), fluid));
        }

        public FluidHangParticle(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions fallParticle) {
            super(level, x, y, z, fluid);
            this.fallingParticle = fallParticle;
            this.f_107225_ = 40;
            this.f_107226_ *= 0.02f;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

