/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import net.dries007.tfc.client.model.animation.AnimationChannel;
import net.dries007.tfc.client.model.animation.AnimationDefinition;
import net.dries007.tfc.client.model.animation.Keyframe;
import net.dries007.tfc.client.model.animation.VanillaAnimations;
import net.dries007.tfc.client.model.entity.HierarchicalAnimatedModel;
import net.dries007.tfc.common.entities.prey.WingedPrey;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PheasantModel
extends HierarchicalAnimatedModel<WingedPrey> {
    public static final AnimationDefinition PHEASANT_WALK = AnimationDefinition.Builder.withLength(1.0417f).looping().addAnimation("body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe(0.0f, VanillaAnimations.posVec(0.0f, -0.3f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, VanillaAnimations.posVec(0.0f, -0.3f, 0.0f), AnimationChannel.Interpolations.LINEAR))).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(15.0f, 0.0f, -1.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(25.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, VanillaAnimations.degreeVec(20.0f, 0.0f, 1.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(25.0f, 0.0f, 0.11547f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, VanillaAnimations.degreeVec(15.0f, 0.0f, -1.5f), AnimationChannel.Interpolations.LINEAR))).addAnimation("legR", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(0.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(-60.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR))).addAnimation("legL", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(-60.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(0.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR))).addAnimation("neck", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(0.0f, 0.0f, 1.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(12.476381f, -1.2497025f, 2.165407f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, VanillaAnimations.degreeVec(0.0f, 0.0f, -1.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(9.910628f, 2.3064368f, -4.4374533f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0417f, VanillaAnimations.degreeVec(0.0f, 0.0f, 1.0f), AnimationChannel.Interpolations.LINEAR))).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(-40.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, VanillaAnimations.degreeVec(-17.5f, 0.0f, -0.5f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(-32.5f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, VanillaAnimations.degreeVec(-15.0f, 0.0f, 0.5f), AnimationChannel.Interpolations.LINEAR))).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe(0.0f, VanillaAnimations.degreeVec(0.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.25f, VanillaAnimations.degreeVec(-10.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.75f, VanillaAnimations.degreeVec(-5.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0416766f, VanillaAnimations.degreeVec(0.0f, 0.0f, 0.0f), AnimationChannel.Interpolations.LINEAR))).build();
    private final ModelPart neck;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart wingR;
    private final ModelPart wingL;
    private final ModelPart tail;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -6.0f, -6.0f, 5.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition legR = body.m_171599_("legR", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 15).m_171488_(-1.5f, 5.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition haunch_r1 = legR.m_171599_("haunch_r1", CubeListBuilder.m_171558_().m_171514_(13, 29).m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition legL = body.m_171599_("legL", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(18, 15).m_171488_(-1.5f, 5.0f, -2.0f, 3.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition haunch_r2 = legL.m_171599_("haunch_r2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.0f, -2.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition wingR = body.m_171599_("wingR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-5.0f, (float)-1.0f));
        PartDefinition main_r1 = wingR.m_171599_("main_r1", CubeListBuilder.m_171558_().m_171514_(13, 17).m_171488_(-1.0f, -1.0f, -2.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.5f, (float)-4.0f, (float)-4.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube1_r1 = neck.m_171599_("cube1_r1", CubeListBuilder.m_171558_().m_171514_(31, 18).m_171488_(-2.0f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-3.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = neck.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-2.5028f, -3.7661f, -1.1073f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.9166f, (float)-0.909f, (float)0.6981f, (float)0.0044f, (float)0.0028f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(28, 12).m_171488_(-1.51f, -2.0436f, -1.001f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-3.8334f, (float)-4.909f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition beak_r1 = head.m_171599_("beak_r1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-0.5f, 2.5f, -2.25f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0436f, (float)-1.001f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = body.m_171599_("wingL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-6.0f, (float)-1.0f));
        PartDefinition main_r2 = wingL.m_171599_("main_r2", CubeListBuilder.m_171558_().m_171514_(22, 21).m_171488_(0.0f, -1.0f, -2.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-2.0f, -2.0f, -1.25f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.25f, (float)3.25f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition end_r1 = tail.m_171599_("end_r1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-1.0f, -1.5f, 0.75f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public PheasantModel(ModelPart root) {
        super(root);
        this.body = root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.legR = this.body.m_171324_("legR");
        this.legL = this.body.m_171324_("legL");
        this.wingR = this.body.m_171324_("wingR");
        this.wingL = this.body.m_171324_("wingL");
        this.tail = this.body.m_171324_("tail");
    }

    public void setupAnim(WingedPrey entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
        float speed = this.getAdjustedLandSpeed(entity);
        this.animate(entity.walkingAnimation, PHEASANT_WALK, ageInTicks, speed);
        if (!entity.m_20096_()) {
            this.wingR.f_104205_ = ageInTicks;
            this.wingL.f_104205_ = -ageInTicks;
        }
        this.neck.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.neck.f_104204_ = headYaw * ((float)Math.PI / 180);
    }
}

