/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.client.model.animation.AnimationChannel;

public record AnimationDefinition(float lengthInSeconds, boolean loop, Map<String, List<AnimationChannel>> boneAnimations) {

    public static class Builder {
        private final float time;
        private final Map<String, List<AnimationChannel>> animationByBone = Maps.newHashMap();
        private boolean looping;

        public static Builder withLength(float seconds) {
            return new Builder(seconds);
        }

        private Builder(float seconds) {
            this.time = seconds;
        }

        public Builder looping() {
            this.looping = true;
            return this;
        }

        public Builder addAnimation(String bone, AnimationChannel channel) {
            this.animationByBone.computeIfAbsent(bone, c -> Lists.newArrayList()).add(channel);
            return this;
        }

        public AnimationDefinition build() {
            return new AnimationDefinition(this.time, this.looping, this.animationByBone);
        }
    }
}

