/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.capabilities.player.PlayerDataCapability;
import net.dries007.tfc.common.entities.TFCFishingHook;
import net.dries007.tfc.config.DisabledExperienceBarStyle;
import net.dries007.tfc.config.HealthDisplayStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;

public class IngameOverlays {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/icons/overlay.png");
    public static final ResourceLocation INK_TEXTURE = Helpers.identifier("textures/misc/ink_splatter.png");
    public static final ResourceLocation GLOW_INK_TEXTURE = Helpers.identifier("textures/misc/glow_ink_splatter.png");
    public static final IIngameOverlay HEALTH = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.PLAYER_HEALTH_ELEMENT, (String)"TerraFirmaCraft Health", IngameOverlays::renderHealth);
    public static final IIngameOverlay MOUNT_HEALTH = OverlayRegistry.registerOverlayAbove((IIngameOverlay)HEALTH, (String)"TerraFirmaCraft Mount Health", IngameOverlays::renderMountHealth);
    public static final IIngameOverlay FOOD = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (String)"TerraFirmaCraft Food Bar", IngameOverlays::renderFood);
    public static final IIngameOverlay THIRST = OverlayRegistry.registerOverlayAbove((IIngameOverlay)FOOD, (String)"TerraFirmaCraft Thirst Bar", IngameOverlays::renderThirst);
    public static final IIngameOverlay INK = OverlayRegistry.registerOverlayTop((String)"TerraFirmaCraft Ink", IngameOverlays::renderInk);
    public static final IIngameOverlay CHISEL = OverlayRegistry.registerOverlayTop((String)"TerraFirmaCraft Chisel Mode", IngameOverlays::renderChiselMode);
    public static final IIngameOverlay EXPERIENCE = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (String)"TerraFirmaCraft EXPERIENCE", IngameOverlays::renderExperience);
    public static final IIngameOverlay JUMP_METER = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (String)"TerraFirmaCraft JUMP METER", IngameOverlays::renderJumpMeter);
    public static final IIngameOverlay HUD_MOVER = OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.PLAYER_HEALTH_ELEMENT, (String)"TerraFirmaCraft HUD MOVER", IngameOverlays::moveLeftAndRightHeights);

    public static void reloadOverlays() {
        boolean enableHealth = (Boolean)TFCConfig.CLIENT.enableHealthBar.get();
        boolean enableFood = (Boolean)TFCConfig.CLIENT.enableHungerBar.get();
        boolean enableThirst = (Boolean)TFCConfig.CLIENT.enableThirstBar.get();
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.PLAYER_HEALTH_ELEMENT, (!enableHealth ? 1 : 0) != 0);
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.MOUNT_HEALTH_ELEMENT, (!enableHealth ? 1 : 0) != 0);
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (!enableFood ? 1 : 0) != 0);
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (boolean)false);
        OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (boolean)false);
        OverlayRegistry.enableOverlay((IIngameOverlay)HEALTH, (boolean)enableHealth);
        OverlayRegistry.enableOverlay((IIngameOverlay)MOUNT_HEALTH, (boolean)enableHealth);
        OverlayRegistry.enableOverlay((IIngameOverlay)FOOD, (boolean)enableFood);
        OverlayRegistry.enableOverlay((IIngameOverlay)THIRST, (boolean)enableThirst);
        OverlayRegistry.enableOverlay((IIngameOverlay)INK, (boolean)((Boolean)TFCConfig.CLIENT.enableInkSplatter.get()));
        OverlayRegistry.enableOverlay((IIngameOverlay)CHISEL, (boolean)true);
        OverlayRegistry.enableOverlay((IIngameOverlay)EXPERIENCE, (boolean)true);
        OverlayRegistry.enableOverlay((IIngameOverlay)JUMP_METER, (boolean)true);
        OverlayRegistry.enableOverlay((IIngameOverlay)HUD_MOVER, ((Boolean)TFCConfig.CLIENT.enableExperienceBar.get() == false ? 1 : 0) != 0);
    }

    public static void renderHealth(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            IngameOverlays.renderHealthBar((LivingEntity)player, gui, stack, width, height);
        }
    }

    public static void renderMountHealth(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            Entity entity = player.m_20202_();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                IngameOverlays.renderHealthBar(entity2, gui, stack, width, height);
            }
        }
    }

    public static void renderFood(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            int x = width / 2;
            int y = height - gui.right_height;
            float percentFood = (float)player.m_36324_().m_38702_() / 20.0f;
            stack.m_85836_();
            stack.m_85837_((double)(x + 1), (double)(y + 4), 0.0);
            gui.m_93228_(stack, 0, 0, 0, 20, 90, 5);
            gui.m_93228_(stack, 0, 0, 0, 25, (int)(90.0f * percentFood), 5);
            stack.m_85849_();
            gui.right_height += 6;
        }
    }

    public static void renderThirst(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (IngameOverlays.setupForSurvival(gui, minecraft)) {
            Player player = (Player)minecraft.m_91288_();
            assert (player != null);
            int x = width / 2;
            int y = height - gui.right_height;
            float percentThirst = 0.0f;
            float overheat = 0.0f;
            FoodData foodData = player.m_36324_();
            if (foodData instanceof TFCFoodData) {
                TFCFoodData data = (TFCFoodData)foodData;
                percentThirst = data.getThirst() / 100.0f;
                overheat = data.getThirstContributionFromTemperature(player);
            }
            stack.m_85836_();
            stack.m_85837_((double)(x + 1), (double)(y + 4), 0.0);
            gui.m_93228_(stack, 0, 0, 90, 20, 90, 5);
            gui.m_93228_(stack, 0, 0, 90, 25, (int)(90.0f * percentThirst), 5);
            if (overheat > 0.0f) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(overheat / 0.4f));
                gui.m_93228_(stack, 0, 0, 90, 30, 90, 5);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            stack.m_85849_();
            gui.right_height += 6;
        }
    }

    private static void renderChiselMode(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        Player player;
        Minecraft mc = Minecraft.m_91087_();
        if (IngameOverlays.setup(gui, mc) && (player = ClientHelpers.getPlayer()) != null && Helpers.isItem(player.m_21120_(InteractionHand.MAIN_HAND), TFCTags.Items.CHISELS)) {
            int u = 60;
            if (Helpers.isItem(player.m_21120_(InteractionHand.OFF_HAND), TFCTags.Items.HAMMERS)) {
                u = player.getCapability(PlayerDataCapability.CAPABILITY).map(cap -> cap.getChiselMode().ordinal() * 20).orElse(0);
            }
            stack.m_85836_();
            gui.m_93228_(stack, width / 2 + 100, height - 21, u, 58, 20, 20);
            stack.m_85849_();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void renderExperience(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        FishingHook fishingHook;
        boolean isStyleLeftHotbar;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        Player player = (Player)mc.m_91288_();
        boolean isShowingExperience = (Boolean)TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (localPlayer != null && (fishingHook = localPlayer.f_36083_) instanceof TFCFishingHook) {
            TFCFishingHook hook = (TFCFishingHook)fishingHook;
            if (IngameOverlays.setup(gui, mc)) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69461_();
                if (!isShowingExperience && isStyleLeftHotbar) {
                    int uOffset;
                    int barHeight;
                    if (player != null && player.m_20202_() instanceof LivingEntity && ((Boolean)TFCConfig.CLIENT.enableHealthBar.get()).booleanValue()) {
                        barHeight = 42;
                        uOffset = 164;
                    } else {
                        barHeight = 32;
                        uOffset = 153;
                    }
                    int x = width / 2 - 97;
                    int y = height - barHeight;
                    int texturePos = 36 + barHeight;
                    int amount = Mth.m_14167_((float)Mth.m_184631_((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)(barHeight + 1)));
                    gui.m_93228_(stack, x, y, uOffset, 36, 5, barHeight);
                    if (amount > 0) {
                        gui.m_93228_(stack, x, height - amount, uOffset + 5, texturePos - amount, 5, amount);
                    }
                } else {
                    int x = width / 2 - 91;
                    int y = height - 29;
                    int amount = Mth.m_14167_((float)Mth.m_184631_((float)hook.pullExhaustion, (float)0.0f, (float)100.0f, (float)0.0f, (float)183.0f));
                    gui.m_93228_(stack, x, y, 0, 111, 182, 5);
                    if (amount > 0) {
                        gui.m_93228_(stack, x, y, 0, 116, amount, 5);
                    }
                }
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                return;
            }
        }
        if (!isShowingExperience) return;
        ForgeIngameGui.EXPERIENCE_BAR_ELEMENT.render(gui, stack, partialTicks, width, height);
    }

    private static void renderJumpMeter(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        boolean isStyleLeftHotbar;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        boolean isShowingExperience = (Boolean)TFCConfig.CLIENT.enableExperienceBar.get();
        boolean bl = isStyleLeftHotbar = TFCConfig.CLIENT.disabledExperienceBarStyle.get() == DisabledExperienceBarStyle.LEFT_HOTBAR;
        if (isShowingExperience || !isShowingExperience && !isStyleLeftHotbar) {
            ForgeIngameGui.JUMP_BAR_ELEMENT.render(gui, stack, partialTicks, width, height);
        } else if (localPlayer != null && localPlayer.m_108633_() && IngameOverlays.setup(gui, mc) && !isShowingExperience && isStyleLeftHotbar) {
            int uOffset;
            int barHeight;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
            if (((Boolean)TFCConfig.CLIENT.enableHealthBar.get()).booleanValue()) {
                barHeight = 42;
                uOffset = 186;
            } else {
                barHeight = 32;
                uOffset = 175;
            }
            int x = width / 2 - 97;
            int y = height - barHeight;
            int texturePos = 36 + barHeight;
            int charge = (int)(localPlayer.m_108634_() * (float)(barHeight + 1));
            gui.m_93228_(stack, x, y, uOffset, 36, 5, barHeight);
            if (charge > 0) {
                gui.m_93228_(stack, x, height - charge, uOffset + 5, texturePos - charge, 5, charge);
            }
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderInk(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        LocalPlayer player;
        if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && (player = Minecraft.m_91087_().f_91074_) != null) {
            if (player.m_21023_((MobEffect)TFCEffects.INK.get())) {
                IngameOverlays.renderTextureOverlay(INK_TEXTURE, 1.0f);
            } else if (player.m_21023_((MobEffect)TFCEffects.GLOW_INK.get())) {
                IngameOverlays.renderTextureOverlay(GLOW_INK_TEXTURE, 1.0f);
            }
        }
    }

    private static void renderHealthBar(LivingEntity entity, ForgeIngameGui gui, PoseStack stack, int width, int height) {
        float f;
        Player player;
        FoodData foodData;
        float surplusPercent;
        Player player2;
        boolean playerHasSaturation;
        HealthDisplayStyle style = (HealthDisplayStyle)((Object)TFCConfig.CLIENT.healthDisplayStyle.get());
        float maxHealth = entity.m_21233_();
        int centerX = width / 2;
        int y = height - gui.left_height;
        stack.m_85836_();
        stack.m_85837_((double)(centerX - 91), (double)y, 0.0);
        gui.m_93228_(stack, 0, 0, 0, 0, 90, 10);
        float absorption = entity.m_6103_();
        absorption = Float.isNaN(absorption) ? 0.0f : absorption;
        float percentHealth = (entity.m_21223_() + absorption) / entity.m_21233_();
        float currentHealth = percentHealth * maxHealth;
        percentHealth = Mth.m_14036_((float)percentHealth, (float)0.0f, (float)1.0f);
        gui.m_93228_(stack, 0, 0, 0, 10, (int)(90.0f * percentHealth), 10);
        boolean isHurt = entity.m_21223_() > 0.0f && entity.m_21223_() < entity.m_21233_();
        boolean bl = playerHasSaturation = entity instanceof Player && (player2 = (Player)entity).m_36324_().m_38722_() > 0.0f;
        if (playerHasSaturation && isHurt || entity.f_20916_ > 0 || entity.m_21023_(MobEffects.f_19605_)) {
            gui.m_93228_(stack, 0, 1, 0, 30, 90, 8);
        }
        if ((surplusPercent = Mth.m_14036_((float)(percentHealth + absorption / 20.0f - 1.0f), (float)0.0f, (float)1.0f)) > 0.0f) {
            float percent = Math.min(surplusPercent, 1.0f);
            gui.m_93228_(stack, 0, 0, 90, 10, (int)(90.0f * percent), 10);
        }
        stack.m_85849_();
        if (entity instanceof Player && (foodData = (player = (Player)entity).m_36324_()) instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            f = data.getHealthModifier();
        } else {
            f = 1.0f;
        }
        float healthModifier = f;
        String text = style.format(currentHealth * healthModifier, maxHealth * healthModifier);
        stack.m_85836_();
        stack.m_85837_((double)(centerX - 45), (double)y + 2.5, 0.0);
        stack.m_85841_(0.8f, 0.8f, 1.0f);
        gui.m_93082_().m_92883_(stack, text, (float)(-1 * gui.m_93082_().m_92895_(text)) / 2.0f, 0.0f, (double)surplusPercent < 0.6 ? Color.WHITE.getRGB() : Color.BLACK.getRGB());
        stack.m_85849_();
        gui.left_height += 10;
    }

    private static void renderTextureOverlay(ResourceLocation location, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void moveLeftAndRightHeights(ForgeIngameGui gui, PoseStack stack, float partialTicks, int width, int height) {
        gui.right_height -= IngameOverlays.considerExperienceConfigs();
        gui.left_height -= IngameOverlays.considerExperienceConfigs();
    }

    private static boolean setupForSurvival(ForgeIngameGui gui, Minecraft minecraft) {
        return gui.shouldDrawSurvivalElements() && IngameOverlays.setup(gui, minecraft);
    }

    public static boolean setup(ForgeIngameGui gui, Minecraft minecraft) {
        if (!minecraft.f_91066_.f_92062_ && minecraft.m_91288_() instanceof Player) {
            gui.setupOverlayRenderState(true, false, TEXTURE);
            return true;
        }
        return false;
    }

    private static int considerExperienceConfigs() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return switch ((DisabledExperienceBarStyle)((Object)TFCConfig.CLIENT.disabledExperienceBarStyle.get())) {
            case DisabledExperienceBarStyle.LEFT_HOTBAR -> 6;
            case DisabledExperienceBarStyle.BUMP -> {
                if (player != null && (player.f_36083_ instanceof TFCFishingHook || player.m_108633_())) {
                    yield 0;
                }
                yield 6;
            }
            default -> 0;
        };
    }
}

