/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.HoeOverlays;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.client.IngameOverlays;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCBubbleColumnAmbientSoundHandler;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.TFCKeyBindings;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.SluiceBlockEntity;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingBonus;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.client.accessor.ClientLevelAccessor;
import net.dries007.tfc.mixin.client.accessor.LocalPlayerAccessor;
import net.dries007.tfc.network.CycleChiselModePacket;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.PlaceBlockSpecialPacket;
import net.dries007.tfc.network.RequestClimateModelPacket;
import net.dries007.tfc.network.StackFoodPacket;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LegacyMaterials;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Pannable;
import net.dries007.tfc.util.PhysicalDamageType;
import net.dries007.tfc.util.Sluiceable;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.tracker.WorldTrackerCapability;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientForgeEventHandler {
    private static final Field CAP_NBT_FIELD = (Field)Helpers.uncheck(() -> {
        Field field = ItemStack.class.getDeclaredField("capNBT");
        field.setAccessible(true);
        return field;
    });
    private static float waterFogLevel = 1.0f;

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayText);
        bus.addListener(ClientForgeEventHandler::onRenderGameOverlayPost);
        bus.addListener(ClientForgeEventHandler::onItemTooltip);
        bus.addListener(ClientForgeEventHandler::onInitGuiPost);
        bus.addListener(ClientForgeEventHandler::onClientWorldLoad);
        bus.addListener(ClientForgeEventHandler::onClientPlayerLoggedIn);
        bus.addListener(ClientForgeEventHandler::onClientTick);
        bus.addListener(ClientForgeEventHandler::onKeyEvent);
        bus.addListener(ClientForgeEventHandler::onScreenKey);
        bus.addListener(ClientForgeEventHandler::onHighlightBlockEvent);
        bus.addListener(ClientForgeEventHandler::onFogRender);
        bus.addListener(ClientForgeEventHandler::onHandRender);
        bus.addListener(ClientForgeEventHandler::onRenderLivingPost);
    }

    public static void onRenderGameOverlayText(RenderGameOverlayEvent.Text event) {
        BlockPos pos;
        Minecraft mc = Minecraft.m_91087_();
        ArrayList list = event.getRight();
        if (mc.f_91073_ != null && mc.f_91066_.f_92063_ && ((Boolean)TFCConfig.CLIENT.enableTFCF3Overlays.get()).booleanValue() && mc.f_91073_.m_7232_((pos = new BlockPos(mc.m_91288_().m_20185_(), mc.m_91288_().m_142469_().f_82289_, mc.m_91288_().m_20189_())).m_123341_() >> 4, pos.m_123343_() >> 4)) {
            list.add("");
            list.add(ChatFormatting.AQUA + "TerraFirmaCraft");
            list.add(Helpers.translatable("tfc.tooltip.calendar_date", Calendars.CLIENT.getCalendarTimeAndDate()).getString());
            if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue()) {
                list.add(String.format("[Debug] Ticks = %d, Calendar = %d, Daytime = %d", Calendars.CLIENT.getTicks(), Calendars.CLIENT.getCalendarTicks(), mc.m_91288_().f_19853_.m_46468_() % 24000L));
            }
            list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_average_temperature", (Object[])new Object[]{ChatFormatting.WHITE + String.format("%.1f", Float.valueOf(ClimateRenderCache.INSTANCE.getAverageTemperature()))}));
            list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_temperature", (Object[])new Object[]{ChatFormatting.WHITE + String.format("%.1f", Float.valueOf(ClimateRenderCache.INSTANCE.getTemperature()))}));
            list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_rainfall", (Object[])new Object[]{ChatFormatting.WHITE + String.format("%.1f", Float.valueOf(ClimateRenderCache.INSTANCE.getRainfall()))}));
            ChunkData data = ChunkData.get((LevelReader)mc.f_91073_, pos);
            if (data.getStatus() == ChunkData.Status.CLIENT) {
                list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_forest_type", (Object[])new Object[0]) + ChatFormatting.WHITE + I18n.m_118938_((String)Helpers.getEnumTranslationKey(data.getForestType()), (Object[])new Object[0]));
                list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_forest_properties", (Object[])new Object[]{ChatFormatting.WHITE + String.format("%.1f%%", Float.valueOf(100.0f * data.getForestDensity())) + ChatFormatting.GRAY, ChatFormatting.WHITE + String.format("%.1f%%", Float.valueOf(100.0f * data.getForestWeirdness())) + ChatFormatting.GRAY}));
            } else {
                list.add(ChatFormatting.GRAY + I18n.m_118938_((String)"tfc.tooltip.f3_invalid_chunk_data", (Object[])new Object[0]));
            }
            mc.f_91073_.getCapability(WorldTrackerCapability.CAPABILITY).ifPresent(cap -> cap.addDebugTooltip(list));
        }
    }

    public static void onRenderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        PoseStack stack = event.getMatrixStack();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null && (event.getType() == RenderGameOverlayEvent.ElementType.ALL && minecraft.f_91080_ == null && Helpers.isItem(player.m_21205_().m_41720_(), TFCTags.Items.HOES) || Helpers.isItem(player.m_21206_().m_41720_(), TFCTags.Items.HOES) && !((Boolean)TFCConfig.CLIENT.showHoeOverlaysOnlyWhenShifting.get()).booleanValue() && player.m_6144_())) {
            HoeOverlays.render(minecraft, event.getWindow(), stack);
        }
    }

    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List text = event.getToolTip();
        if (!stack.m_41619_()) {
            BlockItem bi;
            boolean pan;
            MutableComponent heat;
            Metal metal;
            FluidStack fluid;
            ItemStackInventory inventory;
            HeatingRecipe recipe;
            Fertilizer fertilizer;
            MutableComponent heat2;
            ItemSizeManager.addTooltipInfo(stack, text);
            PhysicalDamageType.addTooltipInfo(stack, text);
            ForgingBonus.addTooltipInfo(stack, text);
            Forging.addTooltipInfo(stack, text);
            stack.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(stack, text));
            stack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(stack, text));
            stack.getCapability(EggCapability.CAPABILITY).ifPresent(cap -> cap.addTooltipInfo(text));
            Fuel fuel = Fuel.get(stack);
            if (fuel != null && (heat2 = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(fuel.getTemperature())) != null) {
                text.add(Helpers.translatable("tfc.tooltip.fuel_burns_at", heat2, Calendars.CLIENT.getTimeDelta(fuel.getDuration())));
            }
            if ((fertilizer = Fertilizer.get(stack)) != null) {
                float n = fertilizer.getNitrogen();
                float p = fertilizer.getPhosphorus();
                float k = fertilizer.getPotassium();
                if (n != 0.0f) {
                    text.add(Helpers.translatable("tfc.tooltip.fertilizer.nitrogen", String.format("%.1f", Float.valueOf(n * 100.0f))));
                }
                if (p != 0.0f) {
                    text.add(Helpers.translatable("tfc.tooltip.fertilizer.phosphorus", String.format("%.1f", Float.valueOf(p * 100.0f))));
                }
                if (k != 0.0f) {
                    text.add(Helpers.translatable("tfc.tooltip.fertilizer.potassium", String.format("%.1f", Float.valueOf(k * 100.0f))));
                }
            }
            if ((recipe = HeatingRecipe.getRecipe(inventory = new ItemStackInventory(stack))) != null && !(fluid = recipe.assembleFluid(inventory)).isEmpty() && (metal = Metal.get(fluid.getFluid())) != null && (heat = ((HeatTooltipStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(recipe.getTemperature())) != null) {
                text.add(Helpers.translatable("tfc.tooltip.item_melts_into", fluid.getAmount() * stack.m_41613_(), Helpers.translatable(metal.getTranslationKey()), heat));
            }
            boolean sluice = Sluiceable.get(stack) != null;
            Item item = stack.m_41720_();
            boolean bl = pan = item instanceof BlockItem && Pannable.get((bi = (BlockItem)item).m_40614_().m_49966_()) != null;
            if (sluice && !pan) {
                text.add(Helpers.translatable("tfc.tooltip.usable_in_sluice").m_130940_(ChatFormatting.GRAY));
            } else if (pan && !sluice) {
                text.add(Helpers.translatable("tfc.tooltip.usable_in_pan").m_130940_(ChatFormatting.GRAY));
            } else if (pan && sluice) {
                text.add(Helpers.translatable("tfc.tooltip.usable_in_sluice_and_pan").m_130940_(ChatFormatting.GRAY));
            }
            if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue() && event.getFlags().m_7050_()) {
                CompoundTag capTag;
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag != null) {
                    text.add(Helpers.literal(ChatFormatting.DARK_GRAY + "[Debug] NBT: " + stackTag));
                }
                if ((capTag = (CompoundTag)Helpers.uncheck(() -> CAP_NBT_FIELD.get(stack))) != null && !capTag.m_128456_()) {
                    text.add(Helpers.literal(ChatFormatting.DARK_GRAY + "[Debug] Cap NBT: " + capTag));
                }
                text.add(Helpers.literal(ChatFormatting.DARK_GRAY + "[Debug] Item Tags: " + Helpers.getHolder(ForgeRegistries.ITEMS, stack.m_41720_()).m_203616_().map(t -> "#" + t.f_203868_()).collect(Collectors.joining(", "))));
                Item item2 = stack.m_41720_();
                if (item2 instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item2;
                    Block block = blockItem.m_40614_();
                    text.add(Helpers.literal(ChatFormatting.DARK_GRAY + "[Debug] Block Tags: " + Helpers.getHolder(ForgeRegistries.BLOCKS, block).m_203616_().map(t -> "#" + t.f_203868_()).collect(Collectors.joining(", "))));
                }
            }
        }
    }

    public static void onInitGuiPost(ScreenEvent.InitScreenEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (player != null && !player.m_7500_()) {
                int guiLeft = screen2.getGuiLeft();
                int guiTop = screen2.getGuiTop();
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 173, 4, 23, 22, 148, 0, 1, 3, 0, 0, button -> {}).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 27, 20, 22, 128, 0, 1, 3, 32, 0, SwitchInventoryTabPacket.Type.CALENDAR).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 50, 20, 22, 128, 0, 1, 3, 64, 0, SwitchInventoryTabPacket.Type.NUTRITION).setRecipeBookCallback(screen2));
                event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 73, 20, 22, 128, 0, 1, 3, 96, 0, SwitchInventoryTabPacket.Type.CLIMATE).setRecipeBookCallback(screen2));
                PatchouliIntegration.ifEnabled(() -> event.addListener((GuiEventListener)new PlayerInventoryTabButton(guiLeft, guiTop, 176, 96, 20, 22, 128, 0, 1, 3, 0, 32, SwitchInventoryTabPacket.Type.BOOK).setRecipeBookCallback(screen2)));
            }
        }
    }

    public static void onClientWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            Object2ObjectArrayMap<ColorResolver, BlockTintCache> colorCaches = ((ClientLevelAccessor)level).accessor$getTintCaches();
            colorCaches.putIfAbsent((Object)TFCColors.FRESH_WATER, (Object)new BlockTintCache(TFCColors::getWaterColor));
            colorCaches.putIfAbsent((Object)TFCColors.SALT_WATER, (Object)new BlockTintCache(TFCColors::getWaterColor));
        }
    }

    public static void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        List<AmbientSoundHandler> handlers;
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new RequestClimateModelPacket());
        LocalPlayer player = event.getPlayer();
        if (player != null && (handlers = ((LocalPlayerAccessor)player).accessor$getAmbientSoundHandlers()).stream().noneMatch(handler -> handler instanceof TFCBubbleColumnAmbientSoundHandler)) {
            handlers.add(new TFCBubbleColumnAmbientSoundHandler(player));
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (event.phase == TickEvent.Phase.END && world != null && !Minecraft.m_91087_().m_91104_()) {
            Calendars.CLIENT.onClientTick();
            ClimateRenderCache.INSTANCE.onClientTick();
        }
    }

    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (TFCKeyBindings.PLACE_BLOCK.m_90857_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new PlaceBlockSpecialPacket());
        } else if (TFCKeyBindings.CYCLE_CHISEL_MODE.m_90857_()) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new CycleChiselModePacket());
        }
    }

    public static void onScreenKey(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        InventoryScreen inv;
        Slot slot;
        Screen screen;
        if (TFCKeyBindings.STACK_FOOD.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode())) && (screen = event.getScreen()) instanceof InventoryScreen && (slot = (inv = (InventoryScreen)screen).getSlotUnderMouse()) != null) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new StackFoodPacket(slot.f_40219_));
        }
    }

    public static void onHighlightBlockEvent(DrawSelectionEvent.HighlightBlock event) {
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        Entity entity = camera.m_90592_();
        Level level = entity.f_19853_;
        BlockHitResult hit = event.getTarget();
        BlockPos pos = hit.m_82425_();
        BlockPos lookingAt = new BlockPos((Vec3i)pos);
        if (lookingAt != null && entity instanceof Player) {
            BlockEntity blockEntity;
            Player player = (Player)entity;
            BlockState stateAt = level.m_8055_(lookingAt);
            Block blockAt = stateAt.m_60734_();
            ChiselRecipe.computeResult(player, stateAt, hit, false).ifLeft(chiseled -> {
                IHighlightHandler.drawBox(poseStack, chiseled.m_60808_((BlockGetter)level, pos), event.getMultiBufferSource(), pos, camera.m_90583_(), 1.0f, 0.0f, 0.0f, 0.4f);
                event.setCanceled(true);
            });
            if (blockAt instanceof IHighlightHandler) {
                IHighlightHandler handler = (IHighlightHandler)blockAt;
                if (handler.drawHighlight(level, lookingAt, player, hit, poseStack, event.getMultiBufferSource(), camera.m_90583_())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof IGhostBlockHandler) {
                IGhostBlockHandler handler = (IGhostBlockHandler)blockAt;
                if (handler.draw(level, player, stateAt, pos, hit.m_82450_(), hit.m_82434_(), event.getPoseStack(), event.getMultiBufferSource(), player.m_21205_())) {
                    event.setCanceled(true);
                }
            } else if (blockAt instanceof SluiceBlock && (blockEntity = level.m_7702_(lookingAt)) instanceof SluiceBlockEntity) {
                BlockState stateAbove;
                SluiceBlockEntity sluice = (SluiceBlockEntity)blockEntity;
                BlockPos waterPos = sluice.getWaterOutputPos();
                if (!((Boolean)stateAt.m_61143_((Property)SluiceBlock.UPPER)).booleanValue()) {
                    waterPos = waterPos.m_142300_(((Direction)stateAt.m_61143_((Property)SluiceBlock.FACING)).m_122424_());
                }
                if (!LegacyMaterials.isReplaceable(level.m_8055_(waterPos))) {
                    IHighlightHandler.drawBox(poseStack, Shapes.m_83144_(), event.getMultiBufferSource(), waterPos, camera.m_90583_(), 0.0f, 0.0f, 1.0f, 0.4f);
                }
                if (!(stateAbove = level.m_8055_(lookingAt.m_7494_())).m_60819_().m_76178_()) {
                    IHighlightHandler.drawBox(poseStack, stateAbove.m_60819_().m_76183_((BlockGetter)level, lookingAt.m_7494_()), event.getMultiBufferSource(), lookingAt.m_7494_(), camera.m_90583_(), 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && event.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            FogType fluid = event.getCamera().m_167685_();
            BlockPos pos = event.getCamera().m_90588_();
            if (fluid == FogType.NONE) {
                float fog = Climate.getFogginess((Level)mc.f_91073_, pos);
                if (fog != 0.0f) {
                    float renderDistance = mc.f_91063_.m_109152_();
                    float density = renderDistance * (1.0f - Math.min(0.86f, fog));
                    event.setNearPlaneDistance(density - Mth.m_14036_((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f));
                    event.setFarPlaneDistance(density);
                    event.setCanceled(true);
                }
            } else if (fluid == FogType.WATER) {
                LocalPlayer player = mc.f_91074_;
                float fog = Climate.getWaterFogginess((Level)mc.f_91073_, pos);
                if (fog != 1.0f) {
                    waterFogLevel = player != null && player.m_21023_(MobEffects.f_19611_) ? 1.0f : Mth.m_14179_((float)0.01f, (float)waterFogLevel, (float)fog);
                    event.scaleFarPlaneDistance(waterFogLevel);
                    event.setCanceled(true);
                } else {
                    waterFogLevel = 1.0f;
                }
            }
        }
    }

    public static void onHandRender(RenderHandEvent event) {
        Player player = ClientHelpers.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof PanItem || mainHand.m_41720_() instanceof EmptyPanItem) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                PoseStack poseStack = event.getPoseStack();
                poseStack.m_85836_();
                RenderHelpers.renderTwoHandedItem(poseStack, event.getMultiBufferSource(), event.getPackedLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), mainHand);
                poseStack.m_85849_();
            }
            event.setCanceled(true);
        }
    }

    public static void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        TFCAnimalProperties animal;
        Entity entity;
        ForgeIngameGui gui;
        Gui gui2;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player.m_6144_() && (gui2 = mc.f_91065_) instanceof ForgeIngameGui && IngameOverlays.setup(gui = (ForgeIngameGui)gui2, mc) && (entity = mc.f_91076_) instanceof TFCAnimalProperties && (animal = (TFCAnimalProperties)entity).getAdultFamiliarityCap() > 0.0f && animal.equals(event.getEntity()) && player.m_19950_(entity, 5.0)) {
            MammalProperties mammal;
            int fontColor;
            int u;
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            stack.m_85837_(0.0, (double)(entity.m_20206_() + 1.2f), 0.0);
            float scale = 0.02666667f;
            stack.m_85841_(-0.02666667f, -0.02666667f, -0.02666667f);
            stack.m_85837_(0.0, 9.374999046325684, 0.0);
            stack.m_85841_(0.5f, 0.5f, 0.5f);
            stack.m_85845_(mc.m_91290_().m_114470_());
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            if (familiarity >= animal.getAdultFamiliarityCap() && animal.getAgeType() != TFCAnimalProperties.Age.CHILD) {
                u = 132;
                fontColor = Color.RED.getRGB();
            } else if (familiarity >= 0.3f) {
                u = 112;
                fontColor = Color.WHITE.getRGB();
            } else {
                u = 92;
                fontColor = Color.GRAY.getRGB();
            }
            if (((Boolean)TFCConfig.CLIENT.displayFamiliarityAsPercent.get()).booleanValue()) {
                String string = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
                stack.m_85837_(0.0, 45.0, 0.0);
                mc.f_91062_.m_92883_(stack, string, (float)(-mc.f_91062_.m_92895_(string)) / 2.0f, 0.0f, fontColor);
            } else {
                gui.m_93228_(stack, -8, 0, u, 40, 16, 16);
                stack.m_85837_(0.0, 0.0, (double)-0.001f);
                gui.m_93228_(stack, -6, 14 - (int)(12.0f * familiarity), familiarity == 1.0f ? 114 : 94, 74 - (int)(12.0f * familiarity), 12, (int)(12.0f * familiarity));
            }
            if (animal instanceof MammalProperties && (mammal = (MammalProperties)animal).getPregnantTime() > 0L && mammal.isFertilized()) {
                stack.m_85837_(0.0, -15.0, 0.0);
                String string = Helpers.translatable("tfc.tooltip.animal.pregnant", entity.m_7755_().getString()).getString();
                mc.f_91062_.m_92883_(stack, string, (float)(-mc.f_91062_.m_92895_(string)) / 2.0f, 0.0f, Color.WHITE.getRGB());
            }
            stack.m_85849_();
        }
    }
}

