/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.entity.custom;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.Util;

public enum BoatEntityVariant {
    ACACIA(0),
    ASH(1),
    ASPEN(2),
    BIRCH(3),
    BLACKWOOD(4),
    CHESTNUT(5),
    DOUGLAS_FIR(6),
    HICKORY(7),
    KAPOK(8),
    MAPLE(9),
    OAK(10),
    PALM(11),
    PINE(12),
    ROSEWOOD(13),
    SEQUOIA(14),
    SPRUCE(15),
    SYCAMORE(16),
    WHITE_CEDAR(17),
    WILLOW(18);

    private static final BoatEntityVariant[] BY_ID;
    private final int id;
    public static final Map<BoatEntityVariant, String> TEXTURE_NAME_BY_VARIANT;

    private BoatEntityVariant(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static BoatEntityVariant byId(int id) {
        return BY_ID[id % BY_ID.length];
    }

    static {
        BY_ID = (BoatEntityVariant[])Arrays.stream(BoatEntityVariant.values()).sorted(Comparator.comparingInt(BoatEntityVariant::getId)).toArray(BoatEntityVariant[]::new);
        TEXTURE_NAME_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(BoatEntityVariant.class), entityVariantMap -> {
            entityVariantMap.put(ACACIA, "acacia");
            entityVariantMap.put(ASH, "ash");
            entityVariantMap.put(ASPEN, "aspen");
            entityVariantMap.put(BIRCH, "birch");
            entityVariantMap.put(BLACKWOOD, "blackwood");
            entityVariantMap.put(CHESTNUT, "chestnut");
            entityVariantMap.put(DOUGLAS_FIR, "douglas_fir");
            entityVariantMap.put(HICKORY, "hickory");
            entityVariantMap.put(KAPOK, "maple");
            entityVariantMap.put(OAK, "oak");
            entityVariantMap.put(PALM, "palm");
            entityVariantMap.put(PINE, "pine");
            entityVariantMap.put(ROSEWOOD, "rosewood");
            entityVariantMap.put(SEQUOIA, "sequoia");
            entityVariantMap.put(SPRUCE, "spruce");
            entityVariantMap.put(SYCAMORE, "sycamore");
            entityVariantMap.put(WHITE_CEDAR, "white_cedar");
            entityVariantMap.put(WILLOW, "willow");
        });
    }
}

