/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.entity.FirmacivBoatRenderer;

import com.hyperdash.firmaciv.entity.custom.KayakEntity;
import com.hyperdash.firmaciv.entity.custom.entitymodel.KayakEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FirmacivKayakRenderer
extends EntityRenderer<KayakEntity> {
    private final Pair<ResourceLocation, KayakEntityModel> kayakResources;
    private static final ResourceLocation KAYAK = new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png");

    public FirmacivKayakRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.f_114477_ = 0.4f;
        this.kayakResources = Pair.of((Object)new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png"), new KayakEntityModel());
    }

    public void render(KayakEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        VertexConsumer vertexconsumer1;
        float f2;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.5, 0.0);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.m_14033_((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), pEntity.getBubbleAngle(pPartialTicks), true));
        }
        Pair<ResourceLocation, KayakEntityModel> pair = this.kayakResources;
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        KayakEntityModel kayakModel = (KayakEntityModel)((Object)pair.getSecond());
        pMatrixStack.m_85837_(0.0, 1.0625, 0.0);
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
        kayakModel.m_6973_(pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(kayakModel.m_103119_(resourcelocation));
        kayakModel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            kayakModel.getWaterocclusion().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        if (!pEntity.m_20197_().isEmpty()) {
            vertexconsumer1 = pBuffer.m_6299_(kayakModel.m_103119_(resourcelocation));
            kayakModel.getCockpitCover().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(KayakEntity pEntity) {
        return new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png");
    }
}

