/*
 * Decompiled with CFR 0.152.
 */
package com.hyperdash.firmaciv.block.custom;

import com.hyperdash.firmaciv.block.FirmacivBlockStateProperties;
import com.hyperdash.firmaciv.block.FirmacivBlocks;
import com.hyperdash.firmaciv.block.blockentity.FirmacivBlockEntities;
import com.hyperdash.firmaciv.block.blockentity.custom.CanoeComponentBlockEntity;
import com.hyperdash.firmaciv.entity.FirmacivEntities;
import com.hyperdash.firmaciv.entity.custom.CanoeEntity;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CanoeComponentBlock
extends BaseEntityBlock {
    public final Supplier<? extends Block> strippedBlock;
    public final Supplier<? extends Item> lumberItem;
    public final CanoeWoodType woodType;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty CANOE_CARVED = FirmacivBlockStateProperties.CANOE_CARVED_13;
    public static final BooleanProperty END = FirmacivBlockStateProperties.END;
    private static final VoxelShape SHAPE_FINAL = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_1 = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        if ((Integer)stateIn.m_61143_((Property)CANOE_CARVED) == 12) {
            double x = (float)pos.m_123341_() + rand.nextFloat();
            double y = (float)pos.m_123342_() + rand.nextFloat();
            double z = (float)pos.m_123343_() + rand.nextFloat();
            for (int i = 0; i < rand.nextInt(3); ++i) {
                level.m_7107_((ParticleOptions)ParticleTypes.f_123778_, x, y, z, 0.0, (double)(0.1f + rand.nextFloat() / 8.0f), 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CanoeComponentBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return CanoeComponentBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)FirmacivBlockEntities.CANOE_COMPONENT_BLOCK_ENTITY.get()), CanoeComponentBlockEntity::serverTick);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public VoxelShape m_5940_(BlockState pstate, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int canoeCarvedState = (Integer)pstate.m_61143_((Property)CANOE_CARVED);
        switch (canoeCarvedState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return SHAPE_1;
            }
        }
        return SHAPE_FINAL;
    }

    public CanoeComponentBlock(BlockBehaviour.Properties properties, CanoeWoodType woodType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_((Property)CANOE_CARVED, (Comparable)Integer.valueOf(1))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
        this.strippedBlock = woodType.stripped;
        this.lumberItem = woodType.lumber;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            CanoeComponentBlock.trySpawnCanoe(pLevel, pPos, (Block)Wood.DOUGLAS_FIR.getBlock(Wood.BlockType.STRIPPED_LOG).get());
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{AXIS});
        pBuilder.m_61104_(new Property[]{CANOE_CARVED});
        pBuilder.m_61104_(new Property[]{END});
    }

    public Item getLumber() {
        return this.lumberItem.get();
    }

    public Block getStrippedLog() {
        return this.strippedBlock.get();
    }

    public static void spawnCanoeWithAxe(Level pLevel, BlockPos pPos, Block strippedLogBlock) {
        CanoeComponentBlock.trySpawnCanoe(pLevel, pPos, strippedLogBlock);
    }

    public static Block getByStripped(Block strippedLogBlock) {
        return (Block)FirmacivBlocks.CANOE_COMPONENT_BLOCKS.values().stream().filter(registryObject -> ((CanoeComponentBlock)((Object)((Object)registryObject.get()))).strippedBlock.get() == strippedLogBlock).map(registryObject -> (CanoeComponentBlock)((Object)((Object)registryObject.get()))).findFirst().get();
    }

    public static boolean isValidCanoeShape(LevelAccessor world, Block strippedLogBlock, BlockPos pPos) {
        Direction.Axis axis = (Direction.Axis)world.m_8055_(pPos).m_61143_(AXIS);
        Block canoeComponentBlock = CanoeComponentBlock.getByStripped(strippedLogBlock);
        BlockPos blockPos0 = pPos;
        int row = 0;
        for (int i = -2; i <= 2; ++i) {
            blockPos0 = pPos.m_142629_(axis, i);
            if (world.m_8055_(blockPos0).m_60713_(strippedLogBlock) || world.m_8055_(blockPos0).m_60713_(canoeComponentBlock)) {
                if (world.m_8055_(blockPos0).m_61143_(AXIS) == axis) {
                    if (++row != 3) continue;
                    return true;
                }
                row = 0;
                continue;
            }
            row = 0;
        }
        return row == 3;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            pLevel.m_46747_(pPos);
        }
        if (!pNewState.m_60713_(pState.m_60734_()) && (Integer)pState.m_61143_((Property)CANOE_CARVED) < 13) {
            Block ccb = pState.m_60734_();
            Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
            if (pLevel.m_8055_(pPos.m_142629_(axis, 1)).m_60713_(ccb) && pLevel.m_8055_(pPos.m_142629_(axis, 1)).m_61143_(AXIS) == axis) {
                pLevel.m_46961_(pPos.m_142629_(axis, 1), true);
            }
            if (pLevel.m_8055_(pPos.m_142629_(axis, -1)).m_60713_(ccb) && pLevel.m_8055_(pPos.m_142629_(axis, -1)).m_61143_(AXIS) == axis) {
                pLevel.m_46961_(pPos.m_142629_(axis, -1), true);
            }
        }
    }

    private static BlockPos getMiddleBlockPos(Level pLevel, BlockPos pPos, Block canoeComponentBlock) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos0 = pPos.m_142629_(axis, 2);
        BlockPos blockPos1 = pPos.m_142629_(axis, 1);
        BlockPos blockPos2 = pPos.m_142629_(axis, -1);
        BlockPos blockPos3 = pPos.m_142629_(axis, -2);
        if (pLevel.m_8055_(blockPos0).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock)) {
            return pPos.m_142629_(axis, 1);
        }
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock)) {
            return pPos;
        }
        if (pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos3).m_60713_(canoeComponentBlock)) {
            return pPos.m_142629_(axis, -1);
        }
        return pPos;
    }

    public static BlockState getStateForPlacement(Level pLevel, Block strippedLogBlock, BlockPos pPos) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        Block canoeComponentBlock = CanoeComponentBlock.getByStripped(strippedLogBlock);
        BlockState finalBlockState = (BlockState)((BlockState)((BlockState)((BlockState)canoeComponentBlock.m_49966_().m_61124_((Property)CANOE_CARVED, (Comparable)Integer.valueOf(1))).m_61124_((Property)END, (Comparable)Boolean.valueOf(true))).m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH));
        BlockPos blockPos1 = pPos.m_142629_(axis, 1);
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) || pLevel.m_8055_(blockPos1).m_60713_(strippedLogBlock) && pLevel.m_8055_(blockPos1).m_61143_(AXIS) == axis) {
            finalBlockState = (BlockState)finalBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH));
        }
        return finalBlockState;
    }

    public static void setEndPieces(Level pLevel, BlockPos pPos, Block canoeComponentBlock, boolean positiveDir) {
        if (!pLevel.m_8055_(pPos).m_60713_(canoeComponentBlock)) {
            return;
        }
        BlockState thisBlockState = pLevel.m_8055_(pPos);
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos1 = pPos.m_142629_(axis, positiveDir ? 1 : -1);
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_61143_(AXIS) == axis) {
            thisBlockState = (BlockState)thisBlockState.m_61124_((Property)END, (Comparable)Boolean.valueOf(false));
            pLevel.m_7731_(pPos, thisBlockState, 4);
            CanoeComponentBlock.setEndPieces(pLevel, blockPos1, canoeComponentBlock, positiveDir);
        } else {
            thisBlockState = (BlockState)thisBlockState.m_61124_((Property)END, (Comparable)Boolean.valueOf(true));
            thisBlockState = positiveDir ? (BlockState)thisBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH)) : (BlockState)thisBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH));
            pLevel.m_7731_(pPos, thisBlockState, 4);
        }
    }

    private static boolean areValidBlockStates(Level pLevel, BlockPos pPos, Block canoeComponentBlock) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos0 = pPos.m_142629_(axis, 2);
        BlockPos blockPos1 = pPos.m_142629_(axis, 1);
        BlockPos blockPos2 = pPos.m_142629_(axis, -1);
        BlockPos blockPos3 = pPos.m_142629_(axis, -2);
        if (pLevel.m_8055_(blockPos0).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && (Integer)pLevel.m_8055_(blockPos0).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos1).m_61143_((Property)CANOE_CARVED) == 13) {
            return true;
        }
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && (Integer)pLevel.m_8055_(blockPos1).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos2).m_61143_((Property)CANOE_CARVED) == 13) {
            return true;
        }
        return pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos3).m_60713_(canoeComponentBlock) && (Integer)pLevel.m_8055_(blockPos2).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos3).m_61143_((Property)CANOE_CARVED) == 13;
    }

    public static void trySpawnCanoe(Level pLevel, BlockPos pPos, Block canoeComponentBlock) {
        if (!CanoeComponentBlock.areValidBlockStates(pLevel, pPos, canoeComponentBlock)) {
            return;
        }
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = CanoeComponentBlock.createCanoeFull(canoeComponentBlock).m_61184_((LevelReader)pLevel, pPos);
        if (blockpattern$blockpatternmatch != null) {
            Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
            BlockPos middleblockpos = CanoeComponentBlock.getMiddleBlockPos(pLevel, pPos, canoeComponentBlock);
            for (int i = 0; i < CanoeComponentBlock.createCanoeFull(canoeComponentBlock).m_61202_(); ++i) {
                BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(0, i, 0);
                pLevel.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                pLevel.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
            }
            CanoeComponentBlock ccb = (CanoeComponentBlock)canoeComponentBlock;
            CanoeEntity canoe = (CanoeEntity)((EntityType)FirmacivEntities.CANOES.get((Object)ccb.woodType.getCanoeType()).get()).m_20615_(pLevel);
            if (axis == Direction.Axis.X) {
                canoe.m_7678_((double)middleblockpos.m_123341_() + 0.5, (double)middleblockpos.m_123342_() + 0.05, (double)middleblockpos.m_123343_() + 0.5, 90.0f, 0.0f);
            } else {
                canoe.m_7678_((double)middleblockpos.m_123341_() + 0.5, (double)middleblockpos.m_123342_() + 0.05, (double)middleblockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            }
            pLevel.m_7967_((Entity)canoe);
            for (ServerPlayer serverplayer : pLevel.m_45976_(ServerPlayer.class, canoe.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)canoe);
            }
            for (int l = 0; l < CanoeComponentBlock.createCanoeFull(canoeComponentBlock).m_61202_(); ++l) {
                BlockInWorld blockinworld3 = blockpattern$blockpatternmatch.m_61229_(0, l, 0);
                pLevel.m_6289_(blockinworld3.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private static BlockPattern createCanoeFull(Block canoeComponentBlock) {
        BlockPattern canoeFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"#", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)canoeComponentBlock))).m_61249_();
        return canoeFull;
    }

    public static enum CanoeWoodType {
        ACACIA((Supplier)((Map)TFCBlocks.WOODS.get(Wood.ACACIA)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.ACACIA), CanoeEntity.Type.ACACIA),
        ASH((Supplier)((Map)TFCBlocks.WOODS.get(Wood.ASH)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.ASH), CanoeEntity.Type.ASH),
        ASPEN((Supplier)((Map)TFCBlocks.WOODS.get(Wood.ASPEN)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.ASPEN), CanoeEntity.Type.ASPEN),
        BIRCH((Supplier)((Map)TFCBlocks.WOODS.get(Wood.BIRCH)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.BIRCH), CanoeEntity.Type.BIRCH),
        BLACKWOOD((Supplier)((Map)TFCBlocks.WOODS.get(Wood.BLACKWOOD)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.BLACKWOOD), CanoeEntity.Type.BLACKWOOD),
        CHESTNUT((Supplier)((Map)TFCBlocks.WOODS.get(Wood.CHESTNUT)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.CHESTNUT), CanoeEntity.Type.CHESTNUT),
        DOUGLAS_FIR((Supplier)((Map)TFCBlocks.WOODS.get(Wood.DOUGLAS_FIR)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.DOUGLAS_FIR), CanoeEntity.Type.DOUGLAS_FIR),
        HICKORY((Supplier)((Map)TFCBlocks.WOODS.get(Wood.HICKORY)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.HICKORY), CanoeEntity.Type.HICKORY),
        KAPOK((Supplier)((Map)TFCBlocks.WOODS.get(Wood.KAPOK)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.KAPOK), CanoeEntity.Type.KAPOK),
        MAPLE((Supplier)((Map)TFCBlocks.WOODS.get(Wood.MAPLE)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.MAPLE), CanoeEntity.Type.MAPLE),
        OAK((Supplier)((Map)TFCBlocks.WOODS.get(Wood.OAK)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.OAK), CanoeEntity.Type.OAK),
        PALM((Supplier)((Map)TFCBlocks.WOODS.get(Wood.PALM)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.PALM), CanoeEntity.Type.PALM),
        PINE((Supplier)((Map)TFCBlocks.WOODS.get(Wood.PINE)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.PINE), CanoeEntity.Type.PINE),
        ROSEWOOD((Supplier)((Map)TFCBlocks.WOODS.get(Wood.ROSEWOOD)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.ROSEWOOD), CanoeEntity.Type.ROSEWOOD),
        SEQUOIA((Supplier)((Map)TFCBlocks.WOODS.get(Wood.SEQUOIA)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.SEQUOIA), CanoeEntity.Type.SEQUOIA),
        SPRUCE((Supplier)((Map)TFCBlocks.WOODS.get(Wood.SPRUCE)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.SPRUCE), CanoeEntity.Type.SPRUCE),
        SYCAMORE((Supplier)((Map)TFCBlocks.WOODS.get(Wood.SYCAMORE)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.SYCAMORE), CanoeEntity.Type.SYCAMORE),
        WHITE_CEDAR((Supplier)((Map)TFCBlocks.WOODS.get(Wood.WHITE_CEDAR)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.WHITE_CEDAR), CanoeEntity.Type.WHITE_CEDAR),
        WILLOW((Supplier)((Map)TFCBlocks.WOODS.get(Wood.WILLOW)).get(Wood.BlockType.STRIPPED_LOG), (Supplier)TFCItems.LUMBER.get(Wood.WILLOW), CanoeEntity.Type.WILLOW);

        public final Supplier<? extends Block> stripped;
        public final Supplier<? extends Item> lumber;
        public final CanoeEntity.Type canoe;

        private CanoeWoodType(Supplier<? extends Block> stripped, Supplier<? extends Item> lumber, CanoeEntity.Type canoe) {
            this.canoe = canoe;
            this.lumber = lumber;
            this.stripped = stripped;
        }

        Block getStrippedWoodByIndex() {
            return this.stripped.get();
        }

        public CanoeEntity.Type getCanoeType() {
            return this.canoe;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

