/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.client.render.cablebus.CubeBuilder;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class PlaneBakedModel
implements IDynamicBakedModel {
    private static final PlaneConnections DEFAULT_PERMUTATION = PlaneConnections.of(false, false, false, false);
    private final TextureAtlasSprite frontTexture;
    private final Map<PlaneConnections, List<BakedQuad>> quads;

    PlaneBakedModel(TextureAtlasSprite frontTexture, TextureAtlasSprite sidesTexture, TextureAtlasSprite backTexture) {
        this.frontTexture = frontTexture;
        this.quads = new HashMap<PlaneConnections, List<BakedQuad>>(PlaneConnections.PERMUTATIONS.size());
        for (PlaneConnections permutation : PlaneConnections.PERMUTATIONS) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(24);
            CubeBuilder builder = new CubeBuilder(quads);
            builder.setTextures(sidesTexture, sidesTexture, frontTexture, backTexture, sidesTexture, sidesTexture);
            boolean minX = !permutation.isRight();
            int maxX = permutation.isLeft() ? 16 : 15;
            boolean minY = !permutation.isDown();
            int maxY = permutation.isUp() ? 16 : 15;
            builder.addCube((float)minX, (float)minY, 0.0f, maxX, maxY, 1.0f);
            this.quads.put(permutation, (List<BakedQuad>)ImmutableList.copyOf(quads));
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        if (side == null) {
            PlaneConnections connections = DEFAULT_PERMUTATION;
            if (modelData.hasProperty(PlaneModelData.CONNECTIONS)) {
                connections = (PlaneConnections)modelData.getData(PlaneModelData.CONNECTIONS);
            }
            return this.quads.get(connections);
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.frontTexture;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

