/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.FacingToRotation;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.BakedPipeline;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadMatrixTransformer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadRotator {
    private static final ThreadLocal<BakedPipeline> pipelines = ThreadLocal.withInitial(() -> BakedPipeline.builder().addElement("transformer", QuadMatrixTransformer.FACTORY).build());
    private static final ThreadLocal<Quad> collectors = ThreadLocal.withInitial(Quad::new);

    public List<BakedQuad> rotateQuads(List<BakedQuad> quads, Direction newForward, Direction newUp) {
        if (newForward == Direction.NORTH && newUp == Direction.UP) {
            return quads;
        }
        FacingToRotation rotation = this.getRotation(newForward, newUp);
        if (rotation.isRedundant()) {
            return quads;
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.f_85811_);
        BakedPipeline pipeline = pipelines.get();
        Quad collector = collectors.get();
        QuadMatrixTransformer transformer = pipeline.getElement("transformer", QuadMatrixTransformer.class);
        Matrix4f mat = new Matrix4f();
        mat.setTranslation(-0.5f, -0.5f, -0.5f);
        mat.multiplyBackward(rotation.getMat());
        mat.m_27648_(new Vector3f(0.5f, 0.5f, 0.5f));
        for (BakedQuad quad : quads) {
            pipeline.reset(format);
            collector.reset(format);
            transformer.setMatrix(mat);
            pipeline.prepare(collector);
            quad.pipe((IVertexConsumer)pipeline);
            int[] data = new int[DefaultVertexFormat.f_85811_.m_86017_() * 4];
            BakedQuad baked = collector.bake();
            if (baked.m_111306_() != null) {
                BlockModel.f_111421_.m_111630_(data, baked.m_111306_());
            }
            result.add(baked);
        }
        return result;
    }

    private FacingToRotation getRotation(Direction forward, Direction up) {
        if (forward.m_122434_() == up.m_122434_()) {
            up = up.m_122434_() == Direction.Axis.Y ? Direction.NORTH : Direction.UP;
        }
        return FacingToRotation.get(forward, up);
    }
}

