/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public final class Tooltip {
    private final List<Component> content;

    public Tooltip(List<Component> unprocessedLines) {
        this.content = new ArrayList<Component>(unprocessedLines.size());
        for (Component unprocessedLine : unprocessedLines) {
            Tooltip.splitLine(unprocessedLine, this.content);
        }
    }

    private static void splitLine(Component unprocessedLine, List<Component> lines) {
        LineSplittingVisitor visitor = new LineSplittingVisitor(lines);
        unprocessedLine.m_7451_((FormattedText.StyledContentConsumer)visitor, Style.f_131099_);
        visitor.flush();
    }

    public Tooltip(Component ... content) {
        this(Arrays.asList(content));
    }

    public List<Component> getContent() {
        return this.content;
    }

    private static class LineSplittingVisitor
    implements FormattedText.StyledContentConsumer<Object> {
        private final List<Component> lines;
        private MutableComponent currentPart;

        public LineSplittingVisitor(List<Component> lines) {
            this.lines = lines;
        }

        public Optional<Object> m_7164_(Style style, String text) {
            String[] parts = text.split("\n", -1);
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    this.flush();
                }
                String line = parts[i];
                MutableComponent part = new TextComponent(line).m_6270_(style);
                this.currentPart = this.currentPart != null ? this.currentPart.m_7220_((Component)part) : part;
            }
            return Optional.empty();
        }

        public void flush() {
            if (this.currentPart != null) {
                if (this.currentPart.m_7383_() == Style.f_131099_) {
                    if (this.lines.isEmpty()) {
                        this.currentPart.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.WHITE));
                    } else {
                        this.currentPart.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY));
                    }
                }
                this.lines.add((Component)this.currentPart);
                this.currentPart = null;
            }
        }
    }
}

