/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.core.definitions.AEItems;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public final class InscriberRecipes {
    public static final ResourceLocation NAMEPLATE_RECIPE_ID = new ResourceLocation("ae2", "nameplate");

    private InscriberRecipes() {
    }

    public static Iterable<InscriberRecipe> getRecipes(Level level) {
        Collection unfilteredRecipes = level.m_7465_().m_44054_(InscriberRecipe.TYPE).values();
        return Iterables.filter(unfilteredRecipes, InscriberRecipe.class);
    }

    @Nullable
    public static InscriberRecipe findRecipe(Level level, ItemStack input, ItemStack plateA, ItemStack plateB, boolean supportNamePress) {
        if (supportNamePress) {
            boolean isNameA = AEItems.NAME_PRESS.isSameAs(plateA);
            boolean isNameB = AEItems.NAME_PRESS.isSameAs(plateB);
            if (isNameA && isNameB || isNameA && plateB.m_41619_()) {
                return InscriberRecipes.makeNamePressRecipe(input, plateA, plateB);
            }
            if (plateA.m_41619_() && isNameB) {
                return InscriberRecipes.makeNamePressRecipe(input, plateB, plateA);
            }
        }
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            boolean matchB;
            boolean matchA = recipe.getTopOptional().test(plateA) && recipe.getBottomOptional().test(plateB);
            boolean bl = matchB = recipe.getTopOptional().test(plateB) && recipe.getBottomOptional().test(plateA);
            if (!matchA && !matchB || !recipe.getMiddleInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    private static InscriberRecipe makeNamePressRecipe(ItemStack input, ItemStack plateA, ItemStack plateB) {
        CompoundTag tag;
        Object name = "";
        if (!plateA.m_41619_()) {
            tag = plateA.m_41784_();
            name = (String)name + tag.m_128461_("InscribeName");
        }
        if (!plateB.m_41619_()) {
            tag = plateB.m_41784_();
            name = (String)name + " " + tag.m_128461_("InscribeName");
        }
        Ingredient startingItem = Ingredient.m_43927_((ItemStack[])new ItemStack[]{input.m_41777_()});
        ItemStack renamedItem = input.m_41777_();
        if (!((String)name).isEmpty()) {
            renamedItem.m_41714_((Component)new TextComponent((String)name));
        } else {
            renamedItem.m_41714_(null);
        }
        InscriberProcessType type = InscriberProcessType.INSCRIBE;
        return new InscriberRecipe(NAMEPLATE_RECIPE_ID, startingItem, renamedItem, plateA.m_41619_() ? Ingredient.f_43901_ : Ingredient.m_43927_((ItemStack[])new ItemStack[]{plateA}), plateB.m_41619_() ? Ingredient.f_43901_ : Ingredient.m_43927_((ItemStack[])new ItemStack[]{plateB}), type);
    }

    public static boolean isValidOptionalIngredientCombination(Level level, ItemStack pressA, ItemStack pressB) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            if ((!recipe.getTopOptional().test(pressA) || !recipe.getBottomOptional().test(pressB)) && (!recipe.getTopOptional().test(pressB) || !recipe.getBottomOptional().test(pressA))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOptionalIngredient(Level level, ItemStack is) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            if (!recipe.getTopOptional().test(is) && !recipe.getBottomOptional().test(is)) continue;
            return true;
        }
        return false;
    }
}

