/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.UpdatePresenceMessage;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class PlayerTeam
extends Team {
    public String playerName = "";
    public boolean online = false;
    public Team actualTeam = this;

    public PlayerTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PLAYER;
    }

    @Override
    protected void serializeExtraNBT(CompoundTag tag) {
        tag.m_128359_("player_name", this.playerName);
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.playerName = tag.m_128461_("player_name");
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.id);
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (playerId.equals(this.id)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    @Override
    public List<ServerPlayer> getOnlineMembers() {
        ServerPlayer p = this.getPlayer();
        return p == null ? Collections.emptyList() : Collections.singletonList(p);
    }

    public void updatePresence() {
        new UpdatePresenceMessage(new KnownClientPlayer(this)).sendToAll(this.manager.server);
    }

    public void createParty(ServerPlayer player, String name, String description, int color, Set<GameProfile> invited) {
        this.createParty(player, name, description, color, invited, true);
    }

    public void createParty(ServerPlayer player, String name, String description, int color, Set<GameProfile> invited, boolean isCommand) {
        try {
            PartyTeam team = (PartyTeam)this.manager.createParty(player, name, description, Color4I.rgb((int)color)).getRight();
            team.invite(player, invited);
        }
        catch (CommandSyntaxException ex) {
            player.m_5661_((Component)new TextComponent(ex.getMessage()).m_130940_(ChatFormatting.RED), false);
        }
    }

    public boolean hasTeam() {
        return this.actualTeam != this;
    }
}

