/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.rhino.RhinoException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EventsJS {
    public final ScriptManager scriptManager;
    private final Map<String, List<ScriptEventHandler>> map;

    public EventsJS(ScriptManager t) {
        this.scriptManager = t;
        this.map = new Object2ObjectOpenHashMap();
    }

    public void listen(String id, IEventHandler handler) {
        ObjectArrayList list = this.map.get(id = id.replace("yeet", "remove"));
        if (list == null) {
            list = new ObjectArrayList();
            this.map.put(id, (List<ScriptEventHandler>)list);
        }
        list.add(new ScriptEventHandler(handler));
    }

    public List<ScriptEventHandler> handlers(String id) {
        List<ScriptEventHandler> list = this.map.get(id);
        return list == null ? Collections.emptyList() : list;
    }

    public boolean postToHandlers(String id, List<ScriptEventHandler> list, EventJS event) {
        if (list.isEmpty()) {
            return false;
        }
        boolean c = event.canCancel();
        for (ScriptEventHandler handler : list) {
            try {
                handler.handler.onEvent(event);
                if (!c || !event.isCancelled()) continue;
                return true;
            }
            catch (RhinoException ex) {
                this.scriptManager.type.console.error("Error occurred while handling event '" + id + "': " + ex.getMessage());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    private static class ScriptEventHandler {
        private final IEventHandler handler;

        private ScriptEventHandler(IEventHandler h) {
            this.handler = h;
        }
    }
}

