/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.jei;

import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.OvenType;
import com.eerussianguy.firmalife.common.recipes.OvenRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.config.HeatTooltipStyle;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class OvenCategory
extends BaseRecipeCategory<OvenRecipe> {
    public OvenCategory(RecipeType<OvenRecipe> type, IGuiHelper helper) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(120, 38), new ItemStack((ItemLike)FLBlocks.CURED_OVEN_TOP.get((Object)OvenType.BRICK).get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 17);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 17);
        List<ItemStack> inputList = List.of(recipe.getIngredient().m_43908_());
        inputSlot.addIngredients((IIngredientType)JEIIntegration.ITEM_STACK, inputList);
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        outputSlot.addItemStacks(OvenCategory.collapse(inputList, (ItemStackProvider)recipe.getResult()));
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
        builder.createFocusLink(new IRecipeSlotBuilder[]{inputSlot, outputSlot});
    }

    public void draw(OvenRecipe recipe, IRecipeSlotsView recipeSlots, PoseStack stack, double mouseX, double mouseY) {
        this.fire.draw(stack, 48, 16);
        this.fireAnimated.draw(stack, 48, 16);
        MutableComponent color = ((HeatTooltipStyle)TFCConfig.CLIENT.heatTooltipStyle.get()).formatColored(recipe.getTemperature());
        if (color != null) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            font.m_92889_(stack, (Component)color, 60.0f - (float)font.m_92852_((FormattedText)color) / 2.0f, 4.0f, 0xFFFFFF);
        }
    }
}

