/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.jei;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.recipes.DryingRecipe;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.eerussianguy.firmalife.common.recipes.MixingBowlRecipe;
import com.eerussianguy.firmalife.common.recipes.OvenRecipe;
import com.eerussianguy.firmalife.common.recipes.SmokingRecipe;
import com.eerussianguy.firmalife.common.recipes.VatRecipe;
import com.eerussianguy.firmalife.compat.jei.DryingCategory;
import com.eerussianguy.firmalife.compat.jei.MixingCategory;
import com.eerussianguy.firmalife.compat.jei.OvenCategory;
import com.eerussianguy.firmalife.compat.jei.SmokingCategory;
import com.eerussianguy.firmalife.compat.jei.VatCategory;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.compat.jei.category.KnappingRecipeCategory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@JeiPlugin
public class FLJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PUMPKIN_TEXTURE = Helpers.identifier((String)"textures/gui/knapping/pumpkin.png");
    public static final RecipeType<DryingRecipe> DRYING = FLJEIPlugin.type("drying", DryingRecipe.class);
    public static final RecipeType<SmokingRecipe> SMOKING = FLJEIPlugin.type("smoking", SmokingRecipe.class);
    public static final RecipeType<MixingBowlRecipe> MIXING_BOWL = FLJEIPlugin.type("mixing_bowl", MixingBowlRecipe.class);
    public static final RecipeType<KnappingRecipe> PUMPKIN_KNAPPING = FLJEIPlugin.type("pumpkin_knapping", KnappingRecipe.class);
    public static final RecipeType<OvenRecipe> OVEN = FLJEIPlugin.type("oven", OvenRecipe.class);
    public static final RecipeType<VatRecipe> VAT = FLJEIPlugin.type("vat", VatRecipe.class);

    private static <C extends Container, T extends Recipe<C>> List<T> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        return level.m_7465_().m_44013_(type);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, Predicate<T> filter) {
        return FLJEIPlugin.getRecipes(type).stream().filter(filter).collect(Collectors.toList());
    }

    private static void addCatalystTag(IRecipeCatalystRegistration r, TagKey<Item> tag, RecipeType<?> recipeType) {
        Helpers.getAllTagValues(tag, (IForgeRegistry)ForgeRegistries.ITEMS).forEach(item -> r.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{recipeType}));
    }

    private static <T> RecipeType<T> type(String name, Class<T> tClass) {
        return RecipeType.create((String)"firmalife", (String)name, tClass);
    }

    public ResourceLocation getPluginUid() {
        return FLHelpers.identifier("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper gui = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new DryingCategory(DRYING, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new SmokingCategory(SMOKING, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new MixingCategory(MIXING_BOWL, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new OvenCategory(OVEN, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new VatCategory(VAT, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new KnappingRecipeCategory(PUMPKIN_KNAPPING, gui, new ItemStack((ItemLike)TFCBlocks.PUMPKIN.get()), PUMPKIN_TEXTURE, null)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        r.addRecipes(DRYING, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.DRYING.get()));
        r.addRecipes(SMOKING, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.SMOKING.get()));
        r.addRecipes(MIXING_BOWL, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.MIXING_BOWL.get()));
        r.addRecipes(OVEN, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.OVEN.get()));
        r.addRecipes(VAT, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.VAT.get()));
        r.addRecipes(PUMPKIN_KNAPPING, FLJEIPlugin.getRecipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.PUMPKIN_KNAPPING.get(), recipe -> recipe.m_7707_() == FLRecipeSerializers.PUMPKIN_KNAPPING.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        FLJEIPlugin.cat(r, FLBlocks.DRYING_MAT, DRYING);
        FLJEIPlugin.cat(r, FLBlocks.SOLAR_DRIER, DRYING);
        FLJEIPlugin.cat(r, (Item)TFCItems.WOOL_YARN.get(), SMOKING);
        FLJEIPlugin.cat(r, FLBlocks.MIXING_BOWL, MIXING_BOWL);
        FLJEIPlugin.cat(r, (Item)FLItems.SPOON.get(), MIXING_BOWL);
        FLJEIPlugin.cat(r, (Supplier<? extends Block>)TFCBlocks.PUMPKIN, PUMPKIN_KNAPPING);
        FLBlocks.CURED_OVEN_TOP.values().forEach(oven -> FLJEIPlugin.cat(r, (Supplier<? extends Block>)oven, OVEN));
        FLJEIPlugin.cat(r, FLBlocks.VAT, VAT);
    }

    private static void cat(IRecipeCatalystRegistration r, Supplier<? extends Block> supplier, RecipeType<?> type) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)supplier.get()), new RecipeType[]{type});
    }

    private static void cat(IRecipeCatalystRegistration r, Item item, RecipeType<?> type) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{type});
    }
}

