/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import java.util.Arrays;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public final class FLPlant
extends Enum<FLPlant>
implements RegistryPlant {
    public static final /* enum */ FLPlant BUTTERFLY_GRASS = new FLPlant(0.8f);
    public static final /* enum */ FLPlant HERB = new FLPlant(0.9f, new int[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0});
    private final float speedFactor;
    @Nullable
    private final IntegerProperty property;
    private final int @Nullable [] stagesByMonth;
    private static final /* synthetic */ FLPlant[] $VALUES;

    public static FLPlant[] values() {
        return (FLPlant[])$VALUES.clone();
    }

    public static FLPlant valueOf(String name) {
        return Enum.valueOf(FLPlant.class, name);
    }

    private FLPlant(float speedFactor) {
        this(speedFactor, null);
    }

    private FLPlant(float speedFactor, int[] stagesByMonth) {
        this.speedFactor = speedFactor;
        this.stagesByMonth = stagesByMonth;
        int maxStage = 0;
        if (stagesByMonth != null) {
            maxStage = Arrays.stream(stagesByMonth).max().orElse(0);
        }
        this.property = maxStage > 0 ? TFCBlockStateProperties.getStageProperty((int)maxStage) : null;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public int stageFor(Month month) {
        assert (this.stagesByMonth != null);
        return this.stagesByMonth.length < month.ordinal() ? 0 : this.stagesByMonth[month.ordinal()];
    }

    @Nullable
    public IntegerProperty getStageProperty() {
        return this.property;
    }

    public BlockBehaviour.Properties solid() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60955_().m_60918_(SoundType.f_56740_).m_60977_();
    }

    public BlockBehaviour.Properties nonSolid() {
        return this.solid().m_60966_().m_60956_(this.speedFactor).m_60910_();
    }

    public ExtendedProperties nonSolidFire() {
        return this.fire(this.nonSolid());
    }

    private ExtendedProperties fire(BlockBehaviour.Properties properties) {
        return ExtendedProperties.of((BlockBehaviour.Properties)properties).flammable(60, 30);
    }

    private static /* synthetic */ FLPlant[] $values() {
        return new FLPlant[]{BUTTERFLY_GRASS, HERB};
    }

    static {
        $VALUES = FLPlant.$values();
    }
}

