/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.blocks.OvenType;
import com.eerussianguy.firmalife.common.items.BeehiveFrameItem;
import com.eerussianguy.firmalife.common.items.FLFood;
import com.eerussianguy.firmalife.common.items.FinishItem;
import com.eerussianguy.firmalife.common.items.HollowShellItem;
import com.eerussianguy.firmalife.common.items.PeelItem;
import com.eerussianguy.firmalife.common.items.SeedBallItem;
import com.eerussianguy.firmalife.common.items.Spice;
import com.eerussianguy.firmalife.common.items.WateringCanItem;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.FLArmorMaterials;
import com.eerussianguy.firmalife.common.util.FLFruit;
import com.eerussianguy.firmalife.common.util.FLMetal;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.DecayingItem;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FLItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"firmalife");
    public static final EnumSet<Food> TFC_FRUITS = EnumSet.of(Food.BANANA, new Food[]{Food.BLACKBERRY, Food.BLUEBERRY, Food.BUNCHBERRY, Food.CHERRY, Food.CLOUDBERRY, Food.CRANBERRY, Food.ELDERBERRY, Food.GOOSEBERRY, Food.GREEN_APPLE, Food.LEMON, Food.OLIVE, Food.ORANGE, Food.PEACH, Food.PLUM, Food.RASPBERRY, Food.RED_APPLE, Food.SNOWBERRY, Food.STRAWBERRY, Food.WINTERGREEN_BERRY});
    public static final RegistryObject<Item> BEEHIVE_FRAME = FLItems.register("beehive_frame", () -> new BeehiveFrameItem(FLItems.prop()));
    public static final RegistryObject<Item> BEESWAX = FLItems.register("beeswax", () -> new HoneycombItem(FLItems.prop()));
    public static final RegistryObject<Item> CINNAMON_BARK = FLItems.register("cinnamon_bark", TFCItemGroup.MISC);
    public static final RegistryObject<Item> CHEESECLOTH = FLItems.register("cheesecloth", TFCItemGroup.MISC);
    public static final RegistryObject<Item> FRUIT_LEAF = FLItems.register("fruit_leaf", TFCItemGroup.MISC);
    public static final RegistryObject<Item> EMPTY_JAR = FLItems.register("empty_jar", TFCItemGroup.MISC);
    public static final RegistryObject<Item> HOLLOW_SHELL = FLItems.register("hollow_shell", () -> new HollowShellItem(FLItems.prop(), (Supplier<Integer>)FLConfig.SERVER.hollowShellCapacity, FLTags.Fluids.USABLE_IN_HOLLOW_SHELL, false, false));
    public static final RegistryObject<Item> ICE_SHAVINGS = FLItems.register("ice_shavings", TFCItemGroup.MISC);
    public static final RegistryObject<Item> OVEN_INSULATION = FLItems.register("oven_insulation", () -> new PeelItem(FLItems.prop()));
    public static final RegistryObject<Item> PEEL = FLItems.register("peel", () -> new PeelItem(FLItems.prop()));
    public static final RegistryObject<Item> PIE_PAN = FLItems.register("pie_pan", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PINEAPPLE_FIBER = FLItems.register("pineapple_fiber", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PINEAPPLE_LEATHER = FLItems.register("pineapple_leather", TFCItemGroup.MISC);
    public static final RegistryObject<Item> PINEAPPLE_YARN = FLItems.register("pineapple_yarn", TFCItemGroup.MISC);
    public static final RegistryObject<Item> RAW_HONEY = FLItems.register("raw_honey", TFCItemGroup.MISC);
    public static final RegistryObject<Item> RENNET = FLItems.register("rennet", TFCItemGroup.MISC);
    public static final RegistryObject<Item> SEED_BALL = FLItems.register("seed_ball", () -> new SeedBallItem(FLItems.prop()));
    public static final RegistryObject<Item> SPOON = FLItems.register("spoon", TFCItemGroup.MISC);
    public static final RegistryObject<Item> TREATED_LUMBER = FLItems.register("treated_lumber", TFCItemGroup.MISC);
    public static final RegistryObject<Item> WATERING_CAN = FLItems.register("watering_can", () -> new WateringCanItem(FLItems.prop().m_41499_(20)));
    public static final RegistryObject<Item> BEEKEEPER_HELMET = FLItems.register("beekeeper_helmet", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final RegistryObject<Item> BEEKEEPER_CHESTPLATE = FLItems.register("beekeeper_chestplate", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, EquipmentSlot.CHEST, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final RegistryObject<Item> BEEKEEPER_LEGGINGS = FLItems.register("beekeeper_leggings", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, EquipmentSlot.LEGS, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final RegistryObject<Item> BEEKEEPER_BOOTS = FLItems.register("beekeeper_boots", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, EquipmentSlot.FEET, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final Map<Spice, RegistryObject<Item>> SPICES = Helpers.mapOfKeys(Spice.class, spice -> FLItems.register("spice/" + spice.name(), TFCItemGroup.MISC));
    public static final Map<FLFood, RegistryObject<Item>> FOODS = Helpers.mapOfKeys(FLFood.class, food -> FLItems.register("food/" + food.name(), () -> new DecayingItem(new Item.Properties().m_41489_(food.getFoodProperties()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<FLFruit, RegistryObject<Item>> FRUITS = Helpers.mapOfKeys(FLFruit.class, food -> FLItems.register("food/" + food.name(), () -> new DecayingItem(new Item.Properties().m_41489_(food.getFoodProperties()).m_41491_(TFCItemGroup.FOOD))));
    public static final Map<OvenType, RegistryObject<Item>> FINISHES = Helpers.mapOfKeys(OvenType.class, type -> type != OvenType.BRICK, type -> FLItems.register(type.getTrueName() + "_finish", () -> new FinishItem(FLItems.prop(), (OvenType)((Object)type))));
    public static final RegistryObject<DynamicBowlFood> FILLED_PIE = FLItems.registerContainerFood("food/filled_pie", false);
    public static final RegistryObject<DynamicBowlFood> COOKED_PIE = FLItems.registerContainerFood("food/cooked_pie");
    public static final RegistryObject<DecayingItem> RAW_PIZZA = FLItems.registerDynamicFood("food/raw_pizza", false);
    public static final RegistryObject<DecayingItem> COOKED_PIZZA = FLItems.registerDynamicFood("food/cooked_pizza");
    public static final RegistryObject<DecayingItem> BURRITO = FLItems.registerDynamicFood("food/burrito");
    public static final RegistryObject<DecayingItem> TACO = FLItems.registerDynamicFood("food/taco");
    public static final RegistryObject<Item> NIGHTSHADE_BERRY = FLItems.register("food/nightshade_berry", () -> new DecayingItem(new Item.Properties().m_41491_(TFCItemGroup.FOOD).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 1, 10), 0.5f).m_38767_())));
    public static final RegistryObject<DynamicBowlFood> STINKY_SOUP = FLItems.register("food/stinky_soup", () -> new DynamicBowlFood(new Item.Properties().m_41491_(TFCItemGroup.FOOD).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 1, 10), 0.5f).m_38767_())));
    public static final Map<Ore.Grade, RegistryObject<Item>> CHROMIUM_ORES = Helpers.mapOfKeys(Ore.Grade.class, grade -> FLItems.register("ore/" + grade.name() + "_chromite", TFCItemGroup.ORES));
    public static final Map<FLMetal, Map<FLMetal.ItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(FLMetal.class, metal -> Helpers.mapOfKeys(FLMetal.ItemType.class, type -> FLItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((FLMetal)((Object)metal)))));
    public static final Map<FLMetal, RegistryObject<BucketItem>> METAL_FLUID_BUCKETS = Helpers.mapOfKeys(FLMetal.class, metal -> FLItems.register("bucket/metal/" + metal.name(), () -> new BucketItem((Supplier)FLFluids.METALS.get(metal).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC))));
    public static final Map<ExtraFluid, RegistryObject<BucketItem>> EXTRA_FLUID_BUCKETS = Helpers.mapOfKeys(ExtraFluid.class, fluid -> FLItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)FLFluids.EXTRA_FLUIDS.get(fluid).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(TFCItemGroup.MISC))));

    private static Item.Properties prop() {
        return new Item.Properties().m_41491_(TFCItemGroup.MISC);
    }

    private static RegistryObject<DecayingItem> registerDynamicFood(String name) {
        return FLItems.registerDynamicFood(name, true);
    }

    private static RegistryObject<DecayingItem> registerDynamicFood(String name, boolean edible) {
        return FLItems.register(name, () -> new DecayingItem(FLItems.foodProperties(edible)));
    }

    private static RegistryObject<DynamicBowlFood> registerContainerFood(String name) {
        return FLItems.registerContainerFood(name, true);
    }

    private static RegistryObject<DynamicBowlFood> registerContainerFood(String name, boolean edible) {
        return FLItems.register(name, () -> new DynamicBowlFood(FLItems.foodProperties(edible)));
    }

    private static Item.Properties foodProperties(boolean edible) {
        Item.Properties properties = new Item.Properties().m_41491_(TFCItemGroup.FOOD);
        if (edible) {
            properties.m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_());
        }
        return properties;
    }

    private static RegistryObject<Item> register(String name, CreativeModeTab group) {
        return FLItems.register(name, () -> new Item(new Item.Properties().m_41491_(group)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

