/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FLFoodTraits {
    public static final FoodTrait DRIED = FLFoodTraits.register(Default.DRIED);
    public static final FoodTrait FRESH = FLFoodTraits.register(Default.FRESH);
    public static final FoodTrait AGED = FLFoodTraits.register(Default.AGED);
    public static final FoodTrait VINTAGE = FLFoodTraits.register(Default.VINTAGE);
    public static final FoodTrait OVEN_BAKED = FLFoodTraits.register(Default.OVEN_BAKED);
    public static final FoodTrait SMOKED = FLFoodTraits.register(Default.SMOKED);
    public static final FoodTrait RANCID_SMOKED = FLFoodTraits.register(Default.RANCID_SMOKED);
    public static final FoodTrait RAW = FLFoodTraits.register(Default.RAW);
    public static final FoodTrait SHELVED = FLFoodTraits.register(Default.SHELVED);
    public static final FoodTrait SHELVED_2 = FLFoodTraits.register(Default.SHELVED_2);
    public static final FoodTrait SHELVED_3 = FLFoodTraits.register(Default.SHELVED_3);
    public static final FoodTrait HUNG = FLFoodTraits.register(Default.HUNG);
    public static final FoodTrait HUNG_2 = FLFoodTraits.register(Default.HUNG_2);
    public static final FoodTrait HUNG_3 = FLFoodTraits.register(Default.HUNG_3);

    public static void init() {
    }

    private static FoodTrait register(Default trait) {
        return FoodTrait.register((ResourceLocation)FLHelpers.identifier(trait.name), (FoodTrait)new WrappedFT(() -> Float.valueOf(((Double)FLConfig.SERVER.foodTraits.get((Object)trait).get()).floatValue()), "firmalife.tooltip.food_trait." + trait.name));
    }

    public static enum Default {
        DRIED(0.5f),
        FRESH(1.1f),
        AGED(0.9f),
        VINTAGE(0.6f),
        OVEN_BAKED(0.9f),
        SMOKED(0.7f),
        RANCID_SMOKED(2.0f),
        RAW(1.0f),
        SHELVED(0.4f),
        SHELVED_2(0.35f),
        SHELVED_3(0.25f),
        HUNG(0.35f),
        HUNG_2(0.3f),
        HUNG_3(0.25f);

        private final float mod;
        private final String name;

        private Default(float mod) {
            this.mod = mod;
            this.name = this.name().toLowerCase(Locale.ROOT);
        }

        public String getName() {
            return this.name;
        }

        public String getCapitalizedName() {
            return this.name.substring(0, 1).toUpperCase(Locale.ROOT) + this.name.substring(1);
        }

        public float getMod() {
            return this.mod;
        }
    }

    private static class WrappedFT
    extends FoodTrait {
        private final Supplier<Float> decayModifier;
        @Nullable
        private final String translationKey;

        public WrappedFT(Supplier<Float> decayModifier, @Nullable String translationKey) {
            super(1.0f, translationKey);
            this.decayModifier = decayModifier;
            this.translationKey = translationKey;
        }

        public float getDecayModifier() {
            return this.decayModifier.get().floatValue();
        }

        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            if (this.translationKey != null) {
                TranslatableComponent component = Helpers.translatable((String)this.translationKey);
                if (this.decayModifier.get().floatValue() > 1.0f) {
                    component.m_130940_(ChatFormatting.RED);
                }
                text.add((Component)component);
            }
        }
    }
}

