/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.SquirtingMoistureTransducerBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import java.util.List;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;

public class SquirtingMoistureTransducerBlock
extends BottomSupportedDeviceBlock
implements HoeOverlayBlock {
    public static final BooleanProperty STASIS = FLStateProperties.STASIS;

    public SquirtingMoistureTransducerBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, Shapes.m_83144_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STASIS, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{STASIS}));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41720_() == ((Block)FLBlocks.EMBEDDED_PIPE.get()).m_5456_()) {
            FLHelpers.consumeInventory(level, pos, FLBlockEntities.SQUIRTING_MOISTURE_TRANSDUCER, (transducer, inv) -> FLHelpers.insertOne(level, held, 0, inv, player));
        }
        return InteractionResult.PASS;
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState blockState, List<Component> text, boolean debug) {
        FLHelpers.readInventory(level, pos, FLBlockEntities.SQUIRTING_MOISTURE_TRANSDUCER, (transducer, inv) -> {
            ItemStack item = inv.getStackInSlot(0);
            if (item.m_41619_()) {
                text.add((Component)Helpers.translatable((String)"firmalife.transducer.no_pipes"));
            } else {
                text.add((Component)Helpers.translatable((String)"firmalife.transducer.current_pipes", (Object[])new Object[]{item.m_41613_()}));
            }
            text.add((Component)Helpers.translatable((String)"firmalife.transducer.pipe_length", (Object[])new Object[]{transducer.getCachedMoisture()}));
            text.add((Component)Helpers.translatable((String)"firmalife.transducer.pipe_wanted", (Object[])new Object[]{SquirtingMoistureTransducerBlockEntity.getMinPipes(level, pos)}));
        });
    }
}

