/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blockentities.SprinklerBlockEntity;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SprinklerBlock
extends DeviceBlock
implements HoeOverlayBlock {
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SprinklerBlock.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[]{SprinklerBlock.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), SprinklerBlock.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), SprinklerBlock.m_49796_((double)10.0, (double)10.0, (double)7.0, (double)13.0, (double)12.0, (double)9.0), SprinklerBlock.m_49796_((double)7.0, (double)10.0, (double)10.0, (double)9.0, (double)12.0, (double)13.0), SprinklerBlock.m_49796_((double)3.0, (double)10.0, (double)7.0, (double)6.0, (double)12.0, (double)9.0), SprinklerBlock.m_49796_((double)7.0, (double)10.0, (double)3.0, (double)9.0, (double)12.0, (double)6.0)});
    private final Function<BlockPos, Iterable<BlockPos>> pathMaker;

    public static SprinklerBlock createSprinkler(ExtendedProperties properties) {
        return new SprinklerBlock(properties, origin -> BlockPos.m_121940_((BlockPos)origin.m_142082_(-2, -6, -2), (BlockPos)origin.m_142082_(2, -1, 2)));
    }

    public static SprinklerBlock createDribbler(ExtendedProperties properties) {
        return new SprinklerBlock(properties, origin -> BlockPos.m_121940_((BlockPos)origin.m_142082_(0, -7, 0), (BlockPos)origin.m_142082_(0, -1, 0)));
    }

    public SprinklerBlock(ExtendedProperties properties, Function<BlockPos, Iterable<BlockPos>> pathMaker) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.pathMaker = pathMaker;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        SprinklerBlockEntity sprinkler;
        BlockEntity blockEntity;
        if ((level.m_46467_() - 10L) % 40L == 0L && (blockEntity = level.m_7702_(pos)) instanceof SprinklerBlockEntity && (sprinkler = (SprinklerBlockEntity)blockEntity).isActive()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175824_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_144128_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), 1.0f, false);
        }
    }

    public Function<BlockPos, Iterable<BlockPos>> getPathMaker() {
        return this.pathMaker;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean debug) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SprinklerBlockEntity) {
            SprinklerBlockEntity sprinkler = (SprinklerBlockEntity)blockEntity;
            text.add((Component)Helpers.translatable((String)(sprinkler.isValid() ? "firmalife.greenhouse.valid_block" : "firmalife.greenhouse.invalid_block")));
        }
    }
}

