/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PlanterType;
import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class QuadPlanterBlock
extends LargePlanterBlock
implements IHighlightHandler {
    private static final VoxelShape SMALL_SHAPE = QuadPlanterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape[] HITBOXES = new VoxelShape[]{QuadPlanterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)6.0, (double)8.0), QuadPlanterBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0), QuadPlanterBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0), QuadPlanterBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)6.0, (double)16.0)};

    public QuadPlanterBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public PlanterType getPlanterType() {
        return PlanterType.QUAD;
    }

    @Override
    protected int getUseSlot(BlockHitResult hit, BlockPos pos) {
        Vec3 trace = hit.m_82450_().m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        return this.getSlotForHit(trace.f_82479_, trace.f_82481_);
    }

    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult hit, PoseStack poseStack, MultiBufferSource buffer, Vec3 renderPos) {
        Vec3 trace = hit.m_82450_().m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        VoxelShape shape = HITBOXES[this.getSlotForHit(trace.f_82479_, trace.f_82481_)];
        IHighlightHandler.drawBox((PoseStack)poseStack, (VoxelShape)shape, (MultiBufferSource)buffer, (BlockPos)pos, (Vec3)renderPos, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SMALL_SHAPE;
    }

    private int getSlotForHit(double hitX, double hitZ) {
        if (hitX > 0.5 && hitZ > 0.5) {
            return 1;
        }
        if (hitX > 0.5 && hitZ < 0.5) {
            return 2;
        }
        if (hitX < 0.5 && hitZ > 0.5) {
            return 3;
        }
        return 0;
    }
}

