/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class IceFishingStationBlock
extends FourWayDeviceBlock {
    public static final VoxelShape[] SHAPES = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)2.0, (double)10.0), Helpers.rotateShape((Direction)dir, (double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)7.0), Helpers.rotateShape((Direction)dir, (double)5.0, (double)0.0, (double)7.0, (double)7.0, (double)2.0, (double)8.0), Helpers.rotateShape((Direction)dir, (double)9.0, (double)0.0, (double)7.0, (double)11.0, (double)2.0, (double)8.0)}));
    public static final BooleanProperty CAST = FLStateProperties.CAST;

    public static boolean canSurvive(LevelReader level, BlockPos pos) {
        return Helpers.isBlock((BlockState)level.m_8055_(pos.m_7495_()), (TagKey)BlockTags.f_13047_);
    }

    public IceFishingStationBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CAST, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.ICE_FISHING_STATION, (station, inv) -> {
            ItemStack inside = station.getRod();
            ItemStack held = player.m_21120_(hand);
            if (inside.m_41619_() && inv.isItemValid(0, held)) {
                player.m_21008_(hand, inv.insertItem(0, held, false));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!inside.m_41619_() && held.m_41619_() && player.m_6144_()) {
                station.withdraw();
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(0, 1, false));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!((Boolean)state.m_61143_((Property)CAST)).booleanValue() && !inside.m_41619_()) {
                if (!station.hasBait() && Helpers.isItem((ItemStack)held, (TagKey)TFCTags.Items.SMALL_FISHING_BAIT) && Helpers.isItem((ItemStack)inside, (TagKey)TFCTags.Items.HOLDS_SMALL_FISHING_BAIT)) {
                    inside.m_41784_().m_128365_("bait", (Tag)held.m_41620_(1).m_41739_(new CompoundTag()));
                    station.markForSync();
                    player.m_5661_((Component)Helpers.translatable((String)"firmalife.fishing.bait_added"), true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (station.hasBait()) {
                    if (!Helpers.isFluid((FluidState)level.m_8055_(station.getBaitPos(state)).m_60819_(), (TagKey)FluidTags.f_13131_)) {
                        player.m_5661_((Component)Helpers.translatable((String)"firmalife.fishing.no_water"), true);
                        return InteractionResult.FAIL;
                    }
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)CAST, (Comparable)Boolean.valueOf(true)));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                player.m_5661_((Component)Helpers.translatable((String)"firmalife.fishing.no_bait"), true);
            } else if (((Boolean)state.m_61143_((Property)CAST)).booleanValue()) {
                if (station.hasHooked()) {
                    station.pullHooked();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (player.m_6144_()) {
                    station.withdraw();
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            return InteractionResult.PASS;
        });
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return IceFishingStationBlock.canSurvive(level, pos);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return IceFishingStationBlock.canSurvive((LevelReader)context.m_43725_(), context.m_8083_()) ? super.m_5573_(context) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !Helpers.isBlock((BlockState)facingState, (TagKey)BlockTags.f_13047_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{CAST}));
    }
}

