/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.BoilingBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.container.StovetopPotContainer;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class StovetopPotBlockEntity
extends BoilingBlockEntity<StovetopPotInventory> {
    public static final int SLOTS = 4;
    private static final int DURATION = 1000;
    private static final float MIN_TEMP = 500.0f;
    private boolean hasRecipe = false;
    private ItemStack soupStack = ItemStack.f_41583_;

    public static void serverTick(Level level, BlockPos pos, BlockState state, StovetopPotBlockEntity pot) {
        pot.checkForLastTickSync();
        pot.checkForCalendarUpdate();
        if (pot.needsRecipeUpdate) {
            pot.updateCachedRecipe();
        }
        pot.tickTemperature();
        pot.handleCooking();
    }

    public StovetopPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.STOVETOP_POT.get(), pos, state, StovetopPotInventory::new, FLHelpers.blockEntityName("stovetop_pot"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[0]), (Predicate)Direction.Plane.HORIZONTAL);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return StovetopPotContainer.create(this, inventory, containerId);
    }

    public boolean hasOutput() {
        return !this.soupStack.m_41619_();
    }

    public void updateCachedRecipe() {
        if (((StovetopPotInventory)this.inventory).getFluidInTank(0).getAmount() >= 100 && this.temperature > 500.0f) {
            int found = 0;
            for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
                if (stack.m_41619_()) continue;
                ++found;
            }
            if (found >= 3) {
                this.hasRecipe = true;
                return;
            }
        }
        this.hasRecipe = false;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem((ItemStack)stack, FLTags.Items.USABLE_IN_STOVETOP_SOUP);
    }

    public void handleCooking() {
        assert (this.f_58857_ != null);
        if (this.isBoiling()) {
            if (this.boilingTicks < 1000) {
                ++this.boilingTicks;
                if (this.boilingTicks == 1) {
                    this.markForSync();
                }
            } else {
                this.assembleSoup();
                this.boilingTicks = 0;
                this.updateCachedRecipe();
                for (int i = 0; i < 4; ++i) {
                    ((StovetopPotInventory)this.inventory).setStackInSlot(i, ItemStack.f_41583_);
                    ((StovetopPotInventory)this.inventory).getFluidHandler().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                }
                this.markForSync();
            }
        } else if (this.boilingTicks > 0) {
            this.boilingTicks = 0;
            this.markForSync();
        }
    }

    public void assembleSoup() {
        FoodData data;
        int ingredientCount = 0;
        float water = 20.0f;
        float saturation = 2.0f;
        float[] nutrition = new float[Nutrient.TOTAL];
        ItemStack soupStack = ItemStack.f_41583_;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = ((StovetopPotInventory)this.inventory).getStackInSlot(i);
            IFood food2 = stack.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
            if (food2 == null) continue;
            if (food2.isRotten()) {
                ingredientCount = 0;
                break;
            }
            data = food2.getData();
            water += data.water();
            saturation += data.saturation();
            Nutrient[] nutrientArray = Nutrient.VALUES;
            int n = nutrientArray.length;
            for (int j = 0; j < n; ++j) {
                Nutrient nutrient = nutrientArray[j];
                int n2 = nutrient.ordinal();
                nutrition[n2] = nutrition[n2] + data.nutrient(nutrient);
            }
            ++ingredientCount;
        }
        if (ingredientCount > 0) {
            float multiplier = 1.0f - 0.05f * (float)ingredientCount;
            water *= multiplier;
            saturation *= multiplier;
            Nutrient maxNutrient = Nutrient.GRAIN;
            float maxNutrientValue = 0.0f;
            for (Nutrient nutrient : Nutrient.VALUES) {
                int idx;
                int n = idx = nutrient.ordinal();
                nutrition[n] = nutrition[n] * multiplier;
                if (!(nutrition[idx] > maxNutrientValue)) continue;
                maxNutrientValue = nutrition[idx];
                maxNutrient = nutrient;
            }
            data = FoodData.create((int)4, (float)water, (float)saturation, (float[])nutrition, (float)3.5f);
            int servings = (int)((float)ingredientCount / 2.0f) + 1;
            long created = FoodCapability.getRoundedCreationDate();
            soupStack = new ItemStack((ItemLike)((RegistryObject)TFCItems.SOUPS.get(maxNutrient)).get(), servings);
            soupStack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlFood.DynamicBowlHandler).ifPresent(food -> {
                DynamicBowlFood.DynamicBowlHandler handler = (DynamicBowlFood.DynamicBowlHandler)food;
                handler.setCreationDate(created);
                handler.setFood(data);
            });
        }
        if (!soupStack.m_41619_()) {
            this.soupStack = soupStack;
        }
    }

    public InteractionResult interactWithOutput(Player player, ItemStack clickedWith) {
        if (Helpers.isItem((Item)clickedWith.m_41720_(), (TagKey)TFCTags.Items.SOUP_BOWLS) && !this.soupStack.m_41619_()) {
            this.soupStack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlFood.DynamicBowlHandler).ifPresent(food -> ((DynamicBowlFood.DynamicBowlHandler)food).setBowl(clickedWith));
            clickedWith.m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.soupStack.m_41620_(1));
            this.markForSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        if (nbt.m_128441_("soup")) {
            this.soupStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("soup"));
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.soupStack.m_41619_()) {
            nbt.m_128365_("soup", (Tag)this.soupStack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public boolean isBoiling() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return this.boilingTicks > 0;
        }
        return this.hasRecipe && this.temperature > 500.0f;
    }

    public static class StovetopPotInventory
    extends BoilingBlockEntity.BoilingInventory {
        public StovetopPotInventory(InventoryBlockEntity<?> entity) {
            super(entity, 4, new InventoryFluidTank(1000, fluid -> fluid.getFluid().m_6212_((Fluid)Fluids.f_76193_), (FluidTankCallback)((StovetopPotBlockEntity)entity)));
        }
    }
}

