/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import com.eerussianguy.firmalife.common.blocks.JarringStationBlock;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.items.JarsBlockItem;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class JarringStationBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 9;
    private int pourTicks = 0;

    public static void tick(Level level, BlockPos pos, BlockState state, JarringStationBlockEntity station) {
        BlockEntity blockEntity;
        station.checkForLastTickSync();
        if (station.pourTicks > 0) {
            --station.pourTicks;
        }
        if (level.m_46467_() % 60L == 0L && state.m_61138_((Property)JarringStationBlock.FACING) && (blockEntity = level.m_7702_(pos.m_142300_((Direction)state.m_61143_((Property)JarringStationBlock.FACING)))) instanceof VatBlockEntity) {
            VatBlockEntity vat = (VatBlockEntity)blockEntity;
            vat.getCapability(Capabilities.FLUID).ifPresent(cap -> {
                FluidStack fluid = cap.getFluidInTank(0);
                int available = fluid.getAmount() / 500;
                if (available > 0 && fluid.hasTag() && fluid.getTag().m_128425_("fruit", 10)) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)fluid.getTag().m_128469_("fruit"));
                    for (int i = 0; i < 9; ++i) {
                        if (((ItemStackHandler)station.inventory).getStackInSlot(i).m_41720_() == FLItems.EMPTY_JAR.get()) {
                            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11770_);
                            ((ItemStackHandler)station.inventory).setStackInSlot(i, Helpers.copyWithSize((ItemStack)stack, (int)1));
                            cap.drain(500, IFluidHandler.FluidAction.EXECUTE);
                            --available;
                            station.markForSync();
                            vat.markForSync();
                            station.pourTicks = 45;
                        }
                        if (available == 0) break;
                    }
                }
            });
        }
    }

    public JarringStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.JARRING_STATION.get(), pos, state, JarringStationBlockEntity.defaultInventory((int)9), FLHelpers.blockEntityName("jarring_station"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), new Direction[]{Direction.DOWN}).on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), (Predicate)Direction.Plane.HORIZONTAL);
    }

    public int getPourTicks() {
        return this.pourTicks;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof JarsBlockItem || stack.m_41720_() == FLItems.EMPTY_JAR.get();
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }
}

