/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.SimpleItemRecipeBlockEntity;
import com.eerussianguy.firmalife.common.recipes.DryingRecipe;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class DryingMatBlockEntity
extends SimpleItemRecipeBlockEntity<DryingRecipe> {
    public static DryingMatBlockEntity dryingMat(BlockPos pos, BlockState state) {
        return new DryingMatBlockEntity((BlockEntityType<DryingMatBlockEntity>)((BlockEntityType)FLBlockEntities.DRYING_MAT.get()), pos, state, (Supplier<Integer>)FLConfig.SERVER.dryingTicks);
    }

    public static DryingMatBlockEntity solarDrier(BlockPos pos, BlockState state) {
        return new DryingMatBlockEntity((BlockEntityType<DryingMatBlockEntity>)((BlockEntityType)FLBlockEntities.SOLAR_DRIER.get()), pos, state, (Supplier<Integer>)FLConfig.SERVER.solarDryingTicks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DryingMatBlockEntity mat) {
        if (mat.needsRecipeUpdate) {
            mat.resetCounter();
        }
        if (level.m_46467_() % 60L == 0L && EnvironmentHelpers.isRainingOrSnowing((Level)level, (BlockPos)pos) && level.m_45527_(pos)) {
            mat.resetCounter();
        }
        if (mat.cachedRecipe != null) {
            if (!((DryingRecipe)mat.cachedRecipe).matches(new ItemStackInventory(((ItemStackHandler)mat.inventory).getStackInSlot(0)), level)) {
                mat.cachedRecipe = null;
                mat.resetCounter();
            } else if (mat.getTicksLeft() <= 0L) {
                mat.finish();
            }
        }
    }

    public DryingMatBlockEntity(BlockEntityType<DryingMatBlockEntity> type, BlockPos pos, BlockState state, Supplier<Integer> dryTicks) {
        super(type, pos, state, FLHelpers.blockEntityName("drying_mat"), dryTicks);
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0}), new Direction[]{Direction.DOWN}).on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0}), (Predicate)Direction.Plane.HORIZONTAL);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        return DryingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack)) != null;
    }

    @Override
    public void updateCache() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = DryingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(this.readStack()));
        this.needsRecipeUpdate = false;
    }
}

