/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.blockentities.TrellisPlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;

public class TrellisPlanterBlockEntityRenderer
implements BlockEntityRenderer<TrellisPlanterBlockEntity> {
    private static final int GROWING_ID = 0;
    private static final int DRY_ID = 1;
    private static final int FLOWERING_ID = 2;
    private static final int FRUITING_ID = 3;

    public void render(TrellisPlanterBlockEntity planter, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        int id = 0;
        if (growth >= 1.0f) {
            id = 3;
        } else if (!water) {
            id = 1;
        } else if (growth > 0.66f) {
            id = 2;
        }
        poseStack.m_85836_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(plant.getTexture(id));
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)combinedLight, (int)combinedOverlay, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.01f, (float)1.0f);
        poseStack.m_85849_();
    }
}

