/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;

public class BonsaiPlanterBlockEntityRenderer
implements BlockEntityRenderer<LargePlanterBlockEntity> {
    private static final int FRUITING_ID = 0;
    private static final int DRY_ID = 1;
    private static final int FLOWERING_ID = 2;
    private static final int BRANCH_ID = 3;
    private static final int LEAVES_ID = 4;

    public void render(LargePlanterBlockEntity planter, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        int id = 4;
        if (growth >= 1.0f) {
            id = 0;
        } else if (!water) {
            id = 1;
        } else if (growth > 0.66f) {
            id = 2;
        }
        TextureAtlasSprite branch = (TextureAtlasSprite)atlas.apply(plant.getTexture(3));
        TextureAtlasSprite leaves = (TextureAtlasSprite)atlas.apply(plant.getTexture(id));
        poseStack.m_85836_();
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)combinedLight, (int)combinedOverlay, (float)0.4375f, (float)0.4375f, (float)0.4375f, (float)0.5625f, (float)1.125f, (float)0.5625f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)combinedLight, (int)combinedOverlay, (float)0.4375f, (float)0.75f, (float)0.25f, (float)0.5625f, (float)0.875f, (float)0.4375f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)combinedLight, (int)combinedOverlay, (float)0.3125f, (float)0.875f, (float)0.5f, (float)0.4375f, (float)1.0f, (float)0.75f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)combinedLight, (int)combinedOverlay, (float)0.25f, (float)0.75f, (float)0.625f, (float)0.625f, (float)1.1875f, (float)1.0f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)combinedLight, (int)combinedOverlay, (float)0.1875f, (float)0.6875f, (float)0.3125f, (float)0.6875f, (float)1.3125f, (float)0.6875f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)combinedLight, (int)combinedOverlay, (float)0.25f, (float)0.625f, (float)0.0625f, (float)0.75f, (float)1.0625f, (float)0.4375f);
        poseStack.m_85849_();
    }
}

