/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.utils;

import carbonconfiglib.utils.ParseResult;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class ParsedCollections {

    public static class ParsedMap
    implements IParsed {
        Map<String, Object> parsed = Object2ObjectMap.builder().linkedMap();

        public ParsedMap() {
        }

        public ParsedMap(String key, Object obj) {
            this.put(key, obj);
        }

        public ParsedMap(Map<String, ? extends Object> c) {
            this.putAll(c);
        }

        public void put(String key, Object obj) {
            this.parsed.put(key, obj);
        }

        public void putAll(Map<String, ? extends Object> c) {
            this.parsed.putAll(c);
        }

        public Set<String> keySet() {
            return Collections.unmodifiableSet(this.parsed.keySet());
        }

        public <T> T get(String key, Class<T> type) {
            Object obj = this.parsed.get(key);
            if (obj instanceof ParseResult) {
                obj = ((ParseResult)obj).getValue();
            }
            return type.isInstance(obj) ? (T)type.cast(obj) : null;
        }

        public <T> ParseResult<T> getOrError(String key, Class<T> type) {
            return this.getOrError(key, type, "Variable [" + key + "] couldn't be parsed");
        }

        public <T> ParseResult<T> getOrError(String key, Class<T> type, String errorMessage) {
            Object obj = this.parsed.get(key);
            if (obj instanceof ParseResult) {
                ParseResult value = (ParseResult)obj;
                return value.validateType(type, errorMessage);
            }
            return ParseResult.error(NullPointerException::new, errorMessage);
        }

        public <T> T getUnsafe(String key) {
            return (T)this.parsed.get(key);
        }

        public String toString() {
            return this.parsed.toString();
        }
    }

    public static class ParsedList
    implements IParsed {
        ObjectList<Object> objects = new ObjectArrayList();

        public ParsedList() {
        }

        public ParsedList(Collection<? extends Object> elements) {
            this.objects.addAll(elements);
        }

        public ParsedList(Object ... elements) {
            this.objects.addAll(elements);
        }

        public void addAll(Collection<? extends Object> elements) {
            this.objects.addAll(elements);
        }

        public void addAll(Object ... elements) {
            this.objects.addAll(elements);
        }

        public void add(Object element) {
            this.objects.add(element);
        }

        public static ParseResult<ParsedList> unwrap(ParsedList list) {
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                Object obj = list.objects.get(i);
                if (!(obj instanceof ParseResult)) continue;
                ParseResult result = (ParseResult)obj;
                if (result.hasError()) {
                    return result.onlyError();
                }
                list.objects.set(i, result.getValue());
            }
            return ParseResult.success(list);
        }

        public int size() {
            return this.objects.size();
        }

        public <T> T get(int index, Class<T> type) {
            Object obj = this.objects.get(index);
            return type.isInstance(obj) ? (T)type.cast(obj) : null;
        }

        public <T> ParseResult<T> getOrError(int index, Class<T> type, String errorMessage) {
            Object obj = this.objects.get(index);
            return type.isInstance(obj) ? ParseResult.success(type.cast(obj)) : ParseResult.error(NullPointerException::new, errorMessage);
        }

        public <T> T getUnsafe(int index) {
            return (T)this.objects.get(index);
        }

        public <T, E extends Collection<T>> E collect(Class<T> type, E output) {
            for (Object obj : this.objects) {
                if (!type.isInstance(obj)) continue;
                output.add(type.cast(obj));
            }
            return (E)output;
        }

        public <T, E extends Collection<T>> E collectCollections(E output) {
            output.addAll(this.objects);
            return (E)output;
        }

        public <T> Iterable<T> typedIterator(final Class<T> type) {
            return () -> new Iterator<T>(){
                Iterator<Object> iter;
                {
                    this.iter = objects.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public T next() {
                    Object obj = this.iter.next();
                    return type.isInstance(obj) ? (Object)type.cast(obj) : null;
                }
            };
        }

        public String toString() {
            return this.objects.toString();
        }
    }

    public static interface IParsed {
    }
}

