/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftValue;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class MinecraftLeaf
implements IConfigNode {
    IGameRuleValue entry;
    MinecraftValue value;

    public MinecraftLeaf(IGameRuleValue entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            this.value = new MinecraftValue(this.entry);
        }
        return this.value;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel(I18n.m_118938_((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public Component getTooltip() {
        Object id = this.entry.getDescriptionId();
        TextComponent result = new TextComponent("");
        result.m_7220_((Component)new TranslatableComponent((String)id).m_130940_(ChatFormatting.YELLOW));
        id = (String)id + ".description";
        if (I18n.m_118936_((String)id)) {
            result.m_130946_("\n").m_7220_((Component)new TranslatableComponent((String)id).m_130940_(ChatFormatting.GRAY));
        }
        return result;
    }
}

